/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;

public class StrUtils {
    public static final char UNDERLINE = '_';

    public static boolean isNumeric(String val) {
        char[] chars = val.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if (c < '0' || c > '9') {
                return false;
            }
            --i;
        }
        return true;
    }

    public static long lastNumber(String val) {
        long num = 0L;
        char[] chars = val.toCharArray();
        if (chars.length == 0) {
            throw new NumberFormatException(val);
        }
        long j = 1L;
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if (c < '0' || c > '9') break;
            int bit = c - 48;
            num += (long)bit * j;
            --i;
            j *= 10L;
        }
        return num;
    }

    public static String firstToLowerCase(String str) {
        return str.toLowerCase().charAt(0) + str.substring(1);
    }

    public static List<String> string2List(String string, String split) {
        String[] strs = new String[]{};
        if (string != null && !string.equals("")) {
            strs = string.split(split);
        }
        ArrayList<String> resultList = new ArrayList<String>(0);
        int i = 0;
        while (i < strs.length) {
            if (strs[i] != null && !strs[i].equals("")) {
                resultList.add(strs[i]);
            }
            ++i;
        }
        resultList.trimToSize();
        return resultList;
    }

    public static String list2String(List<String> list, String split) {
        Object string = "";
        if (CollectionUtils.isEmpty(list)) {
            return string;
        }
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) != null && !list.get(i).equals("")) {
                string = (String)string + list.get(i) + split;
            }
            ++i;
        }
        if (((String)string).length() > 0) {
            string = ((String)string).substring(0, ((String)string).length() - 1);
        }
        return string;
    }

    public static String lineBreak2Blank(String sql) {
        return sql.replaceAll("\r\n+", " \n").replaceAll("\n+", " \n").replaceAll("\t", " ").replaceAll(" +", " ");
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i < len) {
                    sb.append(Character.toUpperCase(param.charAt(i)));
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String underlineToCamel2(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(param);
        Matcher mc = Pattern.compile("_").matcher(param);
        int i = 0;
        while (mc.find()) {
            int position = mc.end() - i++;
            sb.replace(position - 1, position + 1, sb.substring(position, position + 1).toUpperCase());
        }
        return sb.toString();
    }
}

