/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.Operator;

public class Query {
    ArrayList<Condition> conditions = new ArrayList();
    ArrayList<Condition> groupBy;
    ArrayList<Condition> orderBy;

    public static Query builder() {
        return new Query();
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Condition> getOrderBy() {
        return this.orderBy;
    }

    public void joint() {
        Operator lastJoint;
        if (CollectionUtils.isNotEmpty(this.conditions) && !(lastJoint = this.conditions.get(this.conditions.size() - 1).getExpression()).equals((Object)Operator.and) && !lastJoint.equals((Object)Operator.or)) {
            this.and();
        }
    }

    public Query and() {
        this.conditions.add(new Condition(Operator.and, "", null));
        return this;
    }

    public Query or() {
        this.conditions.add(new Condition(Operator.or, "", null));
        return this;
    }

    public Query and(Query subQuery) {
        this.conditions.add(new Condition(Operator.and, "", subQuery));
        return this;
    }

    public Query or(Query subQuery) {
        this.conditions.add(new Condition(Operator.or, "", subQuery));
        return this;
    }

    public Query eq(String column, Object value) {
        this.eq(true, column, value);
        return this;
    }

    public Query ignoreCase(String column, Object value) {
        this.joint();
        this.conditions.add(new Condition(Operator.ignoreCase, column, value));
        return this;
    }

    public Query eq(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.eq, column, value));
        }
        return this;
    }

    public Query notEq(String column, Object value) {
        this.notEq(true, column, value);
        return this;
    }

    public Query notEq(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.notEq, column, value));
        }
        return this;
    }

    public Query in(String column, Object ... value) {
        this.in(true, column, value);
        return this;
    }

    public Query in(boolean expression, String column, Object ... value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.in, column, value));
        }
        return this;
    }

    public Query notIn(String column, Object ... value) {
        this.notIn(true, column, value);
        return this;
    }

    public Query notIn(boolean expression, String column, Object ... value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.notIn, column, value));
        }
        return this;
    }

    public Query gt(String column, Object value) {
        this.gt(true, column, value);
        return this;
    }

    public Query gt(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.gt, column, value));
        }
        return this;
    }

    public Query ge(String column, Object value) {
        this.ge(true, column, value);
        return this;
    }

    public Query ge(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.ge, column, value));
        }
        return this;
    }

    public Query lt(String column, Object value) {
        this.lt(true, column, value);
        return this;
    }

    public Query lt(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.lt, column, value));
        }
        return this;
    }

    public Query le(String column, Object value) {
        this.le(true, column, value);
        return this;
    }

    public Query le(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.le, column, value));
        }
        return this;
    }

    public Query like(String column, Object value) {
        this.like(true, column, value);
        return this;
    }

    public Query like(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.like, column, value));
        }
        return this;
    }

    public Query notLike(String column, Object value) {
        this.notLike(true, column, value);
        return this;
    }

    public Query notLike(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.notLike, column, value));
        }
        return this;
    }

    public Query likeLeft(String column, Object value) {
        this.likeLeft(true, column, value);
        return this;
    }

    public Query likeLeft(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.likeLeft, column, value));
        }
        return this;
    }

    public Query likeRight(String column, Object value) {
        this.likeRight(true, column, value);
        return this;
    }

    public Query likeRight(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.likeRight, column, value));
        }
        return this;
    }

    public Query isNull(String column) {
        this.joint();
        this.conditions.add(new Condition(Operator.isNull, column, null));
        return this;
    }

    public Query isNotNull(String column) {
        this.joint();
        this.conditions.add(new Condition(Operator.isNotNull, column, null));
        return this;
    }

    public Query between(String column, Object value1, Object value2) {
        this.joint();
        this.conditions.add(new Condition(Operator.between, column, value1, value2));
        return this;
    }

    public Query notBetween(String column, Object value1, Object value2) {
        this.joint();
        this.conditions.add(new Condition(Operator.notBetween, column, value1, value2));
        return this;
    }

    public Query condition(String conditionSql) {
        this.joint();
        this.conditions.add(new Condition(Operator.condition, conditionSql, null));
        return this;
    }

    public Query groupBy(String column) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList();
        }
        this.groupBy.add(new Condition(Operator.group, column, ""));
        return this;
    }

    public Query orderBy(String column, String orderType) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        this.orderBy.add(new Condition(Operator.order, column, orderType));
        return this;
    }

    public List<Condition> getGroupBy() {
        return this.groupBy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Query [conditions=");
        builder.append(this.conditions);
        builder.append(", groupBy=");
        builder.append(this.groupBy);
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }

    public static final class OrderType {
        public static final String ASC = "asc";
        public static final String DESC = "desc";
    }
}

