/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.id.impl;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Calendar;
import java.util.Date;
import org.dromara.mybatis.jpa.id.IdentifierGenerator;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlakeIdGenerator
implements IdentifierGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SnowFlakeIdGenerator.class);
    private static final long START_STMP = 1480166465631L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATACENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATACENTER_LEFT = 17L;
    private static final long TIMESTMP_LEFT = 22L;
    private long datacenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;
    private String dateTime;

    public SnowFlakeIdGenerator() {
    }

    public SnowFlakeIdGenerator(InetAddress inetAddress) {
        long id = 0L;
        try {
            NetworkInterface network;
            if (inetAddress == null) {
                inetAddress = InetAddress.getLocalHost();
            }
            if ((network = NetworkInterface.getByInetAddress(inetAddress)) == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (mac != null) {
                    id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
                    id %= this.datacenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            logger.error(" getDatacenterId Exception", (Throwable)e);
        }
    }

    public SnowFlakeIdGenerator(long datacenterId, long machineId) {
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't be greater than MAX_DATACENTER_NUM or less than 0");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.datacenterId = datacenterId;
        this.machineId = machineId;
    }

    public SnowFlakeIdGenerator(long datacenterId, long machineId, long sequence, long lastStmp) {
        this.datacenterId = datacenterId;
        this.machineId = machineId;
        this.sequence = sequence;
        this.lastStmp = lastStmp;
        DateTime datetime = new DateTime((Object)SnowFlakeIdGenerator.fromatTime(lastStmp), (Chronology)ISOChronology.getInstanceUTC());
        this.dateTime = datetime.toString();
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1480166465631L << 22 | this.datacenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }

    public SnowFlakeIdGenerator parse(long id) {
        String sonwFlakeId = Long.toBinaryString(id);
        logger.debug("SonwFlake Id {}", (Object)sonwFlakeId);
        int len = sonwFlakeId.length();
        int sequenceStart = (int)((long)len < 12L ? 0L : (long)len - 12L);
        int workerStart = (int)((long)len < 17L ? 0L : (long)len - 17L);
        int timeStart = (int)((long)len < 22L ? 0L : (long)len - 22L);
        String parseSequence = sonwFlakeId.substring(sequenceStart, len);
        String workerId = sequenceStart == 0 ? "0" : sonwFlakeId.substring(workerStart, sequenceStart);
        String dataCenterId = workerStart == 0 ? "0" : sonwFlakeId.substring(timeStart, workerStart);
        String time = timeStart == 0 ? "0" : sonwFlakeId.substring(0, timeStart);
        int sequenceInt = Integer.valueOf(parseSequence, 2);
        int workerIdInt = Integer.valueOf(workerId, 2);
        int dataCenterIdInt = Integer.valueOf(dataCenterId, 2);
        long diffTime = Long.parseLong(time, 2);
        long timeLong = diffTime + 1480166465631L;
        return new SnowFlakeIdGenerator(dataCenterIdInt, workerIdInt, sequenceInt, timeLong);
    }

    private static Date fromatTime(long date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        return calendar.getTime();
    }

    public long getDatacenterId() {
        return this.datacenterId;
    }

    public void setDatacenterId(long datacenterId) {
        this.datacenterId = datacenterId;
    }

    public long getMachineId() {
        return this.machineId;
    }

    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getLastStmp() {
        return this.lastStmp;
    }

    public void setLastStmp(long lastStmp) {
        this.lastStmp = lastStmp;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    @Override
    public String generate(Object object) {
        return "" + this.nextId();
    }
}

