/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements.transforms;

import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.xmlsig.elements.Transform;

public class Base64Transform
extends Transform {
    public static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#base64";

    public Base64Transform() {
        super(algorithmUri);
    }

    public Base64Transform(String algorithmUri) {
        super(algorithmUri);
    }

    public boolean transformsToOctetStream() {
        return true;
    }

    public boolean consumesRawOctetStream() {
        return true;
    }

    public byte[] transformToOctetStream(byte[] b) {
        return Base64.decode(new String(b));
    }

    public byte[] transformToOctetStream(DOMCursor cursor, DOMCursor orig) {
        return Base64.decode(cursor.getText());
    }

    public DOMCursor transformToNodeSet(DOMCursor cursor, DOMCursor orig) {
        this.throwBadState((Transform)this, cursor);
        return null;
    }

    public DOMCursor transformToNodeSet(byte[] b) {
        this.throwBadState((Transform)this, b);
        return null;
    }

    public String toString() {
        return "[Base64Transform]";
    }
}

