/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tsik.c14n.CanonicalizerFactory;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.resource.ResourceFactory;
import org.apache.tsik.resource.XMLResource;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlsig.elements.HmacOutputLength;
import org.apache.tsik.xmlsig.elements.Transform;
import org.apache.tsik.xmlsig.elements.transforms.CanonicalizationTransform;

public class Transforms
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$elements$Transforms == null ? (class$org$apache$tsik$xmlsig$elements$Transforms = Transforms.class$("org.apache.tsik.xmlsig.elements.Transforms")) : class$org$apache$tsik$xmlsig$elements$Transforms);
    private static String name = "Transforms";
    private static String prefix = Namespaces.XMLSIG.getPrefix();
    private static String uri = Namespaces.XMLSIG.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private Vector transformVector = new Vector();
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$elements$Transforms;

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        Enumeration enumer = this.transformVector.elements();
        while (enumer.hasMoreElements()) {
            Transform t = (Transform)enumer.nextElement();
            t.toXml(wc);
        }
    }

    public static Transforms fromXml(DOMCursor cursor) {
        DOMCursor cc = Transforms.placeCursor(cursor, name, prefix, uri, ns);
        HmacOutputLength hol = HmacOutputLength.fromXml(cc);
        String attributeString = cc.getAttribute("Attribute");
        Transforms transforms = new Transforms();
        boolean exitTransformFound = false;
        Vector<Transform> v = new Vector<Transform>();
        boolean more = cc.moveToChild(Transform.uri, Transform.name);
        while (more) {
            Transform transform = Transform.fromXml(cc);
            if (transform.transformsToOctetStream()) {
                exitTransformFound = true;
            }
            v.add(transform);
            more = cc.moveToSibling(Transform.uri, Transform.name);
        }
        if (!exitTransformFound) {
            v.add(new CanonicalizationTransform());
        }
        transforms.addTransforms(v);
        return transforms;
    }

    private void addTransforms(Vector v) {
        this.transformVector = v;
    }

    public void addTransform(Transform t) {
        this.transformVector.add(t);
    }

    private DOMCursor asCursor(byte[] b) {
        if (log.isDebugEnabled()) {
            log.debug("converting octet stream into node-set");
        }
        XMLResource xmlres = ResourceFactory.getXMLResource();
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        try {
            return new DOMCursor(xmlres.parseXML(is, false));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public byte[] transform(DOMCursor cursor) {
        Transform t;
        boolean copied;
        DOMCursor c;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(cursor);
            c = wc;
            copied = true;
        } else {
            c = cursor.cloneCursor();
            copied = false;
        }
        byte[] bytes = null;
        Enumeration enumer = this.transformVector.elements();
        while (enumer.hasMoreElements()) {
            t = (Transform)enumer.nextElement();
            if (log.isDebugEnabled()) {
                log.debug("excuting " + t);
            }
            if (t.transformsToOctetStream()) {
                bytes = t.transformToOctetStream(c, cursor);
                break;
            }
            t.transformToNodeSet(c, cursor);
        }
        if (!copied) {
            enumer = this.transformVector.elements();
            while (enumer.hasMoreElements()) {
                t = (Transform)enumer.nextElement();
                t.restoreNodeSet();
            }
        }
        return bytes;
    }

    public byte[] transform(byte[] b) {
        DOMCursor c = null;
        boolean previousReturnedBytes = true;
        Enumeration enumer = this.transformVector.elements();
        while (enumer.hasMoreElements()) {
            Transform t = (Transform)enumer.nextElement();
            if (log.isDebugEnabled()) {
                log.debug("excuting " + t);
            }
            boolean toBytes = t.transformsToOctetStream();
            if (t.consumesRawOctetStream()) {
                if (!previousReturnedBytes) {
                    this.badState(t, null);
                }
                if (toBytes) {
                    b = t.transformToOctetStream(b);
                } else {
                    c = t.transformToNodeSet(b);
                }
            } else {
                if (previousReturnedBytes) {
                    c = this.asCursor(b);
                }
                if (c == null) {
                    this.badState(t, c);
                }
                if (toBytes) {
                    b = t.transformToOctetStream(c, null);
                } else {
                    c = t.transformToNodeSet(c, null);
                }
            }
            previousReturnedBytes = toBytes;
        }
        return b;
    }

    private void badState(Transform t, DOMCursor c) {
        throw new IllegalStateException("Transformation order mismatch: " + t + " cannot consume input " + c);
    }

    public String toString() {
        String s = "[Transforms";
        Enumeration enumer = this.transformVector.elements();
        while (enumer.hasMoreElements()) {
            Transform t = (Transform)enumer.nextElement();
            s = s + t;
        }
        s = s + "]";
        return s;
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = Transforms.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            log.debug(e.toString());
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

