/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.xmlsig.Asn1;
import org.apache.tsik.xmlsig.VerifyingKey;
import org.apache.tsik.xmlsig.elements.KeyInfo;
import org.w3c.dom.Element;

public class DSAVerifyingKey
implements VerifyingKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private DSAPublicKey publicKey;
    private KeyInfo keyInfo = null;

    public DSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public DSAVerifyingKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Bad key type: " + publicKey);
        }
        this.publicKey = (DSAPublicKey)publicKey;
        this.keyInfo = new KeyInfo();
        this.keyInfo.addKeyValue(publicKey);
    }

    public DSAVerifyingKey(X509Certificate[] cert) throws InvalidKeyException, CertificateException {
        if (cert == null || cert[0] == null) {
            throw new IllegalArgumentException("certificate chain cannot be null");
        }
        this.keyInfo = new KeyInfo();
        this.keyInfo.addCertificateChain(cert);
        this.keyInfo.explodeCertificate();
        PublicKey publicKey = cert[0].getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Bad key type: " + publicKey);
        }
        this.publicKey = (DSAPublicKey)publicKey;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature sig = Signature.getInstance("DSS");
            sig.initVerify(this.publicKey);
            sig.update(data);
            if (!Asn1.isDerEncodedSequence(sigd)) {
                if (sigd == null || sigd.length != 40) {
                    String s = "Illegal signature value. Length is not the required 40 bytes.";
                    throw new SignatureException(s);
                }
                byte[] r = new byte[20];
                System.arraycopy(sigd, 0, r, 0, 20);
                byte[] s = new byte[20];
                System.arraycopy(sigd, 20, s, 0, 20);
                sigd = Asn1.derEncode(Asn1.os2ip(r), Asn1.os2ip(s));
            }
            return sig.verify(sigd);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (SignatureException se) {
            throw se;
        }
    }

    public void readKeyInfo(Element keyInfoElement) {
    }

    public void writeKeyInfo(Element keyInfoElement) {
        if (this.keyInfo != null) {
            DOMWriteCursor wc = new DOMWriteCursor();
            this.keyInfo.toXml(wc);
            DOMWriteCursor copyTo = new DOMWriteCursor(keyInfoElement);
            boolean more = wc.moveToChild(1);
            while (more) {
                copyTo.copyUnder(wc);
                more = wc.moveToSibling(1);
            }
        }
    }

    public String toString() {
        return "[DSAVerifyingKey]";
    }
}

