/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.elements;

import java.security.cert.CertificateException;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.common.SchemaMapper;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.wss.Id;
import org.apache.tsik.wss.elements.KeyIdentifier;

public class SecurityTokenReference
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$wss$elements$SecurityTokenReference == null ? (class$org$apache$tsik$wss$elements$SecurityTokenReference = SecurityTokenReference.class$("org.apache.tsik.wss.elements.SecurityTokenReference")) : class$org$apache$tsik$wss$elements$SecurityTokenReference);
    private static Class c = class$org$apache$tsik$wss$elements$SecurityTokenReference == null ? (class$org$apache$tsik$wss$elements$SecurityTokenReference = SecurityTokenReference.class$("org.apache.tsik.wss.elements.SecurityTokenReference")) : class$org$apache$tsik$wss$elements$SecurityTokenReference;
    public static String elementName = SchemaMapper.getName(c);
    static String prefix = SchemaMapper.getPrefix(c);
    public static String uri = SchemaMapper.getUri(c);
    private static String[] ns = new String[]{prefix, uri};
    private String id;
    private KeyIdentifier keyIdentifier;
    private String reference;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$SecurityTokenReference;

    public SecurityTokenReference(KeyIdentifier keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public SecurityTokenReference(String reference) {
        this.reference = reference;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean hasKeyIdentifier() {
        return this.keyIdentifier != null;
    }

    public boolean hasReference() {
        return this.reference != null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, elementName);
        if (this.id != null) {
            Id.insertInto(wc, this.id);
        }
        if (this.keyIdentifier != null) {
            this.keyIdentifier.toXml(wc);
        }
        if (this.reference != null) {
            wc = wc.addUnder(uri, prefix, "Reference");
            wc.setAttribute("URI", "#" + this.reference);
        }
    }

    public static SecurityTokenReference fromXml(DOMCursor cursor) {
        DOMCursor c = SecurityTokenReference.placeCursor(cursor, elementName, prefix, uri, ns);
        String id = c.getAttribute(Id.uri, Id.attributeName);
        KeyIdentifier keyIdentifier = null;
        String reference = null;
        if (c.moveToChild(KeyIdentifier.uri, KeyIdentifier.elementName)) {
            try {
                keyIdentifier = KeyIdentifier.fromXml(c);
            }
            catch (CertificateException e) {
                log.warn(e);
            }
            c.moveToParent();
        }
        if (c.moveToChild(uri, "Reference")) {
            reference = c.getAttribute("URI");
            c.moveToParent();
        }
        if (keyIdentifier == null && reference == null) {
            throw new IllegalArgumentException("Need key identifier or reference");
        }
        SecurityTokenReference str = null;
        if (keyIdentifier != null) {
            str = new SecurityTokenReference(keyIdentifier);
        } else {
            reference = new StringBuffer(reference).substring(1).toString();
            str = new SecurityTokenReference(reference);
        }
        str.setId(id);
        return str;
    }

    public String toString() {
        String s = "[SecurityTokenReference";
        if (this.id != null) {
            s = s + " id=" + this.id;
        }
        if (this.keyIdentifier != null) {
            s = s + " keyIdentifier=" + this.keyIdentifier;
        }
        if (this.reference != null) {
            s = s + " reference=" + this.reference;
        }
        return s + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

