/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.c14n;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.tsik.c14n.AbstractCanonicalizer;
import org.apache.tsik.c14n.AttributeComparator;
import org.apache.tsik.c14n.Canonicalizer;
import org.apache.tsik.c14n.SAXHandler;
import org.apache.tsik.resource.DOMOperations;
import org.apache.tsik.resource.ResourceFactory;
import org.apache.tsik.resource.XMLResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

class StreamCanonicalizer
implements Canonicalizer {
    private static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String PI_PREFIX = "<?";
    private static final String PI_SUFFIX = "?>";
    private static final String ELEM_PREFIX = "<";
    private static final String ELEM_SUFFIX = ">";
    private static final String ELEM_END_PREFIX = "</";
    private static final char SPACE = ' ';
    private static final char QUOTE = '\"';
    private static final String EQUAL_QUOTE = "=\"";
    private static final String COMMENT_PREFIX = "<!--";
    private static final String COMMENT_SUFFIX = "-->";
    private static final XMLResource xml = ResourceFactory.getXMLResource();
    private static final Document staticDoc = xml.createDocument();
    private static final AttributeComparator attributeComparator = new AttributeComparator();
    private DOMOperations ops;
    private boolean exclusive;
    private boolean includeComments;
    private List includePrefixes;
    private NamespaceSupport inScopeNamespaces;
    private NamespaceSupport renderedNamespaces;
    private boolean atTopElement;
    private ByteArrayOutputStream baos;
    private OutputStreamWriter writer;

    StreamCanonicalizer(boolean exclusive, boolean includeComments) {
        this.exclusive = exclusive;
        this.includeComments = includeComments;
        this.ops = DOMOperations.getInstance();
        this.baos = new ByteArrayOutputStream(8192);
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.baos, "UTF8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInclusivePrefixList(List list) {
        this.includePrefixes = list;
    }

    public byte[] canonicalize(Node node, Map parentNamespaces) {
        Element elem;
        this.ops = new DOMOperations(node);
        this.inScopeNamespaces = new NamespaceSupport();
        NamespaceSupport namespaceSupport = this.renderedNamespaces = this.exclusive ? new NamespaceSupport() : null;
        if (parentNamespaces != null) {
            this.addToNamespaceContext(this.inScopeNamespaces, parentNamespaces);
        }
        if (node.getNodeType() == 1 && (elem = (Element)node) != elem.getOwnerDocument().getDocumentElement()) {
            elem = (Element)elem.getParentNode();
            this.addToNamespaceContext(this.inScopeNamespaces, this.ops.getInScopeNamespaces(elem));
        }
        this.baos.reset();
        this.atTopElement = true;
        try {
            this.processNode(node);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.baos.toByteArray();
    }

    public SAXHandler getSAXHandler(Map parentNamespaces) throws UnsupportedOperationException {
        this.inScopeNamespaces = new NamespaceSupport();
        NamespaceSupport namespaceSupport = this.renderedNamespaces = this.exclusive ? new NamespaceSupport() : null;
        if (parentNamespaces != null) {
            this.addToNamespaceContext(this.inScopeNamespaces, parentNamespaces);
        }
        this.baos.reset();
        this.atTopElement = true;
        return new Handler();
    }

    private void addToNamespaceContext(NamespaceSupport context, Map add) {
        Iterator i = add.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)add.get(prefix);
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            this.inScopeNamespaces.declarePrefix(prefix, uri);
        }
    }

    public byte[] getSAXResult() throws UnsupportedOperationException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.baos.toByteArray();
    }

    private void processNode(Node node) throws IOException {
        this.processNodeStart(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processNode(child);
        }
        this.processNodeEnd(node);
    }

    private void processNodeStart(Node node) throws IOException {
        short type = node.getNodeType();
        switch (type) {
            case 8: {
                this.processComment(node.getNodeValue());
                break;
            }
            case 1: {
                int len;
                ArrayList<Node> attrs = null;
                NamedNodeMap attrMap = node.getAttributes();
                if (attrMap != null && (len = attrMap.getLength()) > 0) {
                    attrs = new ArrayList<Node>(len);
                    for (int i = 0; i < len; ++i) {
                        attrs.add(attrMap.item(i));
                    }
                }
                this.processElemStart(node.getNodeName(), this.ops.getPrefix(node), this.ops.getNamespaceURI(node), attrs);
                break;
            }
            case 3: 
            case 4: {
                this.processChars(node.getNodeValue());
                break;
            }
            case 7: {
                String data = node.getNodeValue();
                this.processPI(node.getNodeName(), data);
            }
        }
    }

    private void processNodeEnd(Node node) throws IOException {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                this.processElemEnd(node.getNodeName());
            }
        }
    }

    private void processPI(String name, String data) throws IOException {
        this.writer.write(PI_PREFIX);
        this.writer.write(name);
        if (data != null && data.length() > 0) {
            this.writer.write(32);
            this.writer.write(data);
        }
        this.writer.write(PI_SUFFIX);
    }

    private void processComment(String text) throws IOException {
        if (this.includeComments) {
            this.writer.write(COMMENT_PREFIX);
            this.writer.write(text);
            this.writer.write(COMMENT_SUFFIX);
        }
    }

    private void processComment(char[] chars, int off, int len) throws IOException {
        if (this.includeComments) {
            this.writer.write(COMMENT_PREFIX);
            this.writer.write(chars, off, len);
            this.writer.write(COMMENT_SUFFIX);
        }
    }

    private void processChars(String text) throws IOException {
        text = AbstractCanonicalizer.escape(false, text);
        this.writer.write(text);
    }

    private void processChars(char[] chars, int off, int len) throws IOException {
        String s = AbstractCanonicalizer.escape(false, chars, off, len);
        if (s != null) {
            this.writer.write(s);
        } else {
            this.writer.write(chars, off, len);
        }
    }

    private void processElemStart(String qname, String prefix, String uri, List attrs) throws IOException {
        if (attrs == null) {
            attrs = new ArrayList();
        }
        this.writer.write(ELEM_PREFIX);
        this.writer.write(qname);
        this.inScopeNamespaces.pushContext();
        if (this.renderedNamespaces != null) {
            this.renderedNamespaces.pushContext();
        }
        if (this.exclusive) {
            this.processAttrsExclusive(qname, prefix, uri, attrs);
        } else {
            this.processAttrsNormal(attrs);
        }
        this.writer.write(ELEM_SUFFIX);
        this.atTopElement = false;
    }

    private void processAttrsNormal(List attrs) throws IOException {
        if (this.atTopElement) {
            AllPrefixes prefixes = new AllPrefixes(this.inScopeNamespaces);
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                String val = this.inScopeNamespaces.getURI(prefix);
                boolean found = false;
                for (int i = 0; i < attrs.size() && !found; ++i) {
                    Attr attr = (Attr)attrs.get(i);
                    if (!AttributeComparator.isNamespaceAttr(attr) || !prefix.equals(this.getNamespaceAttrPrefix(attr))) continue;
                    found = true;
                }
                if (found) continue;
                attrs.add(this.createNamespaceAttr(prefix, val));
            }
            if (attrs.size() > 1) {
                Collections.sort(attrs, attributeComparator);
            }
            for (int i = 0; i < attrs.size(); ++i) {
                Attr attr = (Attr)attrs.get(i);
                this.renderAttr(attr);
                if (!AttributeComparator.isNamespaceAttr(attr)) continue;
                String prefix = this.getNamespaceAttrPrefix(attr);
                String val = attr.getNodeValue();
                this.inScopeNamespaces.declarePrefix(prefix, val);
            }
        } else {
            if (attrs.size() > 1) {
                Collections.sort(attrs, attributeComparator);
            }
            for (int i = 0; i < attrs.size(); ++i) {
                Attr attr = (Attr)attrs.get(i);
                if (AttributeComparator.isNamespaceAttr(attr)) {
                    String prefix = this.getNamespaceAttrPrefix(attr);
                    String val = attr.getNodeValue();
                    String uri = this.inScopeNamespaces.getURI(prefix);
                    if (this.uriEqual(uri, val)) continue;
                    this.renderAttr(attr);
                    this.inScopeNamespaces.declarePrefix(prefix, val);
                    continue;
                }
                this.renderAttr(attr);
            }
        }
    }

    private void processAttrsExclusive(String elemQName, String elemPrefix, String elemUri, List attrs) throws IOException {
        Attr attr;
        int i;
        String uri;
        String val;
        String prefix;
        for (int i2 = 0; i2 < attrs.size(); ++i2) {
            boolean mustInclude;
            String val2;
            Attr attr2 = (Attr)attrs.get(i2);
            if (!AttributeComparator.isNamespaceAttr(attr2)) continue;
            String prefix2 = this.getNamespaceAttrPrefix(attr2);
            String uri2 = this.inScopeNamespaces.getURI(prefix2);
            boolean inScope = this.uriEqual(uri2, val2 = attr2.getNodeValue());
            boolean bl = mustInclude = !inScope && this.includePrefixes != null && this.includePrefixes.contains(prefix2);
            if (!inScope) {
                this.inScopeNamespaces.declarePrefix(prefix2, val2);
            }
            if (mustInclude) {
                this.renderedNamespaces.declarePrefix(prefix2, val2);
                continue;
            }
            attrs.remove(i2);
            --i2;
        }
        if (this.atTopElement) {
            AllPrefixes prefixes = new AllPrefixes(this.inScopeNamespaces);
            while (prefixes.hasNext()) {
                String prefix3 = (String)prefixes.next();
                if (prefix3.equals("xml") || this.includePrefixes == null || !this.includePrefixes.contains(prefix3) || this.renderedNamespaces.getURI(prefix3) != null) continue;
                String val3 = this.inScopeNamespaces.getURI(prefix3);
                attrs.add(this.createNamespaceAttr(prefix3, val3));
                this.inScopeNamespaces.declarePrefix(prefix3, val3);
                this.renderedNamespaces.declarePrefix(prefix3, val3);
            }
        }
        if ((prefix = elemPrefix) == null) {
            prefix = "";
        }
        if ((val = elemUri) == null) {
            val = "";
        }
        if (!this.uriEqual(uri = this.renderedNamespaces.getURI(prefix), val)) {
            attrs.add(this.createNamespaceAttr(prefix, val));
            this.renderedNamespaces.declarePrefix(prefix, val);
        }
        for (i = 0; i < attrs.size(); ++i) {
            attr = (Attr)attrs.get(i);
            if (AttributeComparator.isNamespaceAttr(attr) || (prefix = this.ops.getPrefix(attr)) == null) continue;
            val = this.ops.getNamespaceURI(attr);
            if (val == null) {
                val = "";
            }
            if (this.uriEqual(uri = this.renderedNamespaces.getURI(prefix), val)) continue;
            attrs.add(this.createNamespaceAttr(prefix, val));
            this.renderedNamespaces.declarePrefix(prefix, val);
        }
        if (attrs.size() > 1) {
            Collections.sort(attrs, attributeComparator);
        }
        for (i = 0; i < attrs.size(); ++i) {
            attr = (Attr)attrs.get(i);
            this.renderAttr(attr);
        }
    }

    private void renderAttr(Attr attr) throws IOException {
        String val = attr.getNodeValue();
        if (AttributeComparator.isNamespaceAttr(attr)) {
            String prefix = this.getNamespaceAttrPrefix(attr);
            if (prefix.equals("xml")) {
                return;
            }
            if (this.atTopElement && prefix.length() == 0 && val.length() == 0) {
                return;
            }
        }
        this.writer.write(32);
        this.writer.write(attr.getNodeName());
        this.writer.write(EQUAL_QUOTE);
        this.writer.write(AbstractCanonicalizer.escape(true, val));
        this.writer.write(34);
    }

    private void processElemEnd(String qname) throws IOException {
        this.writer.write(ELEM_END_PREFIX);
        this.writer.write(qname);
        this.writer.write(ELEM_SUFFIX);
        this.inScopeNamespaces.popContext();
        if (this.renderedNamespaces != null) {
            this.renderedNamespaces.popContext();
        }
    }

    private boolean uriEqual(String uri1, String uri2) {
        if (uri1 == null) {
            uri1 = "";
        }
        if (uri2 == null) {
            uri2 = "";
        }
        return uri1.equals(uri2);
    }

    private String getNamespaceAttrPrefix(Attr attr) {
        String name = this.ops.getLocalName(attr);
        if ("xmlns".equals(name)) {
            name = "";
        }
        return name;
    }

    private Attr createNamespaceAttr(String prefix, String uri) {
        String qname = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        Attr nsAttr = staticDoc.createAttributeNS(NS_XMLNS, qname);
        nsAttr.setValue(uri);
        return nsAttr;
    }

    private static class AllPrefixes
    implements Iterator {
        private NamespaceSupport namespaces;
        private Enumeration prefixes;

        AllPrefixes(NamespaceSupport namespaces) {
            this.namespaces = namespaces;
            this.prefixes = namespaces.getPrefixes();
            this.hasNext();
        }

        public boolean hasNext() {
            if (this.prefixes != null) {
                if (this.prefixes.hasMoreElements()) {
                    return true;
                }
                this.prefixes = null;
            }
            return this.namespaces != null && this.namespaces.getURI("") != null;
        }

        public Object next() {
            if (this.prefixes != null) {
                if (this.prefixes.hasMoreElements()) {
                    return this.prefixes.nextElement();
                }
                this.prefixes = null;
            }
            if (this.namespaces != null && this.namespaces.getURI("") != null) {
                this.namespaces = null;
                return "";
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Handler
    implements SAXHandler {
        private Handler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String uri, String localName, String qname, Attributes saxAttrs) throws SAXException {
            int len = saxAttrs.getLength();
            ArrayList<Attr> attrs = null;
            if (len > 0) {
                attrs = new ArrayList<Attr>(len);
                for (int i = 0; i < len; ++i) {
                    Attr attr = staticDoc.createAttributeNS(saxAttrs.getURI(i), saxAttrs.getQName(i));
                    attr.setValue(saxAttrs.getValue(i));
                    attrs.add(attr);
                }
            }
            String prefix = null;
            int qnameLen = qname.length();
            int localNameLen = localName.length();
            if (localNameLen != qnameLen) {
                prefix = qname.substring(0, qnameLen - localNameLen - 1);
            }
            try {
                StreamCanonicalizer.this.processElemStart(qname, prefix, uri, attrs);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            try {
                StreamCanonicalizer.this.processElemEnd(qname);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                StreamCanonicalizer.this.processChars(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            try {
                StreamCanonicalizer.this.processChars(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            try {
                StreamCanonicalizer.this.processPI(target, data);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                StreamCanonicalizer.this.processComment(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }
}

