/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.mybatis.jpa.AbstractStatementHandlerInterceptor;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.persistence.JpaBaseService;
import org.apache.mybatis.jpa.persistence.JpaPagination;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class StatementHandlerInterceptor
extends AbstractStatementHandlerInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Method m = invocation.getMethod();
        if ("prepare".equals(m.getName())) {
            return this.prepare(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Object prepare(Invocation invocation) throws Throwable {
        StatementHandler statement = this.getStatementHandler(invocation);
        if (statement instanceof SimpleStatementHandler || statement instanceof PreparedStatementHandler) {
            JpaPagination pagination;
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            Object parameterObject = metaObject.getValue("parameterHandler.parameterObject");
            BoundSql boundSql = statement.getBoundSql();
            String sql = boundSql.getSql();
            if (parameterObject instanceof JpaPagination && sql.toUpperCase().trim().startsWith("SELECT") && (pagination = (JpaPagination)parameterObject).isPageable()) {
                this._logger.debug("prepare  boundSql  ==> " + this.removeBreakingWhitespace(sql));
                if (statement instanceof SimpleStatementHandler) {
                    sql = this.dialect.getLimitString(sql, pagination);
                } else if (statement instanceof PreparedStatementHandler) {
                    JpaBaseService.pageResultsBoundSqlCache.put((Object)pagination.getPageResultSelectUUID(), (Object)new PageResultsSqlCache(sql, boundSql));
                    sql = this.dialect.getLimitString(sql, pagination);
                }
                this._logger.debug("prepare dialect boundSql : " + this.removeBreakingWhitespace(sql));
                metaObject.setValue("boundSql.sql", (Object)sql);
            }
        }
        return invocation.proceed();
    }
}

