/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.validator;

import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class EntityDescriptorSchemaValidator
implements Validator<EntityDescriptor> {
    public void validate(EntityDescriptor entityDescriptor) throws ValidationException {
        this.validateEntityID(entityDescriptor);
        this.validateDescriptors(entityDescriptor);
    }

    protected void validateEntityID(EntityDescriptor entityDescriptor) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)entityDescriptor.getEntityID())) {
            throw new ValidationException("Entity ID required.");
        }
        if (entityDescriptor.getEntityID().length() > 1024) {
            throw new ValidationException("Max Entity ID length is 1024.");
        }
    }

    protected void validateDescriptors(EntityDescriptor entityDescriptor) throws ValidationException {
        if ((entityDescriptor.getRoleDescriptors() == null || entityDescriptor.getRoleDescriptors().size() < 1) && entityDescriptor.getAffiliationDescriptor() == null) {
            throw new ValidationException("Must have an AffiliationDescriptor or one or more RoleDescriptors.");
        }
        if (entityDescriptor.getAffiliationDescriptor() != null && entityDescriptor.getRoleDescriptors() != null && entityDescriptor.getRoleDescriptors().size() > 0) {
            throw new ValidationException("Cannot have an AffiliationDescriptor AND RoleDescriptors");
        }
    }
}

