/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.jdbc.HGClob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class HGClobOutputStream
extends OutputStream {
    private HGClob parentClob;
    private long currentPos;

    public HGClobOutputStream(HGClob currentClob, long position) {
        this.parentClob = currentClob;
        this.currentPos = position;
    }

    @Override
    public void write(byte[] srcByteArray) throws IOException {
        this.write(srcByteArray, 0, srcByteArray.length);
    }

    @Override
    public void write(byte[] srcByteArray, int offset, int length) throws IOException {
        if (srcByteArray == null) {
            return;
        }
        try {
            String str = new String(srcByteArray, offset, length, "ASCII");
            int i = this.parentClob.setString(this.currentPos, str);
            this.currentPos += (long)i;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] srcByteArray = new byte[]{(byte)(b & 0xFF)};
        this.write(srcByteArray);
    }
}

