/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.services;

import org.maxkey.client.oauth.exceptions.OAuthSignatureException;
import org.maxkey.client.oauth.services.SignatureService;
import org.maxkey.client.utils.HttpEncoder;
import org.maxkey.client.utils.Preconditions;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "PLAINTEXT";

    @Override
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return HttpEncoder.encode(apiSecret) + '&' + HttpEncoder.encode(tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

