/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.oauth;

import org.maxkey.client.http.HttpVerb;
import org.maxkey.client.http.Response;
import org.maxkey.client.oauth.builder.ServiceBuilder;
import org.maxkey.client.oauth.builder.api.MaxkeyPasswordApi20;
import org.maxkey.client.oauth.model.OAuthConfig;
import org.maxkey.client.oauth.model.OAuthRequest;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.oauth.oauth.OAuthService;

public class OAuthPasswordService {
    private OAuthConfig config;
    private MaxkeyPasswordApi20 passwordApi20;

    public OAuthPasswordService() {
    }

    public OAuthPasswordService(OAuthConfig config, MaxkeyPasswordApi20 passwordApi20) {
        this.passwordApi20 = passwordApi20;
        this.config = config;
    }

    public Token getAccessToken(String username, String password) {
        try {
            String accessTokenUrl = this.passwordApi20.getAuthorizationUrl(this.config, username, password);
            System.out.println(accessTokenUrl);
            OAuthRequest oauthRequest = new OAuthRequest(HttpVerb.GET, accessTokenUrl);
            Response response = oauthRequest.send();
            return this.passwordApi20.getAccessTokenExtractor().extract(response.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Response sendRequest(Token accessToken, HttpVerb requestMethod, String requestUrl) {
        OAuthRequest oauthRequest = new OAuthRequest(requestMethod, requestUrl);
        ServiceBuilder builder = new ServiceBuilder().provider(this.passwordApi20).apiKey(this.config.getApiKey()).apiSecret(this.config.getApiSecret()).callback(this.config.getCallback());
        OAuthService oAuthService = builder.build();
        oAuthService.signRequest(accessToken, oauthRequest);
        return oauthRequest.send();
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public void setConfig(OAuthConfig config) {
        this.config = config;
    }

    public MaxkeyPasswordApi20 getPasswordApi20() {
        return this.passwordApi20;
    }

    public void setPasswordApi20(MaxkeyPasswordApi20 passwordApi20) {
        this.passwordApi20 = passwordApi20;
    }
}

