/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.oauth;

import org.maxkey.client.http.HttpVerb;
import org.maxkey.client.http.Response;
import org.maxkey.client.oauth.builder.api.DefaultApi20;
import org.maxkey.client.oauth.builder.api.MaxkeyApi20;
import org.maxkey.client.oauth.model.OAuthConfig;
import org.maxkey.client.oauth.model.OAuthRequest;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.oauth.model.Verifier;
import org.maxkey.client.oauth.oauth.OAuthService;

public class OAuth20ServiceImpl
implements OAuthService {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;
    private final OAuthConfig config;

    public OAuth20ServiceImpl(DefaultApi20 api, OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    public OAuth20ServiceImpl(String clientId, String clientSecret, String redirectUri) {
        this.api = new MaxkeyApi20();
        this.config = new OAuthConfig(clientId, clientSecret, redirectUri);
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        if (this.api.getAccessTokenVerb().equals((Object)HttpVerb.GET)) {
            request.addQuerystringParameter("client_id", this.config.getApiKey());
            request.addQuerystringParameter("client_secret", this.config.getApiSecret());
            request.addQuerystringParameter("code", verifier.getValue());
            request.addQuerystringParameter("redirect_uri", this.config.getCallback());
            if (this.config.hasScope()) {
                request.addQuerystringParameter("scope", this.config.getScope());
            }
        } else {
            request.getBodyParams().add("client_id", this.config.getApiKey());
            request.getBodyParams().add("client_secret", this.config.getApiSecret());
            request.getBodyParams().add("code", verifier.getValue());
            request.getBodyParams().add("redirect_uri", this.config.getCallback());
            request.getBodyParams().add("grant_type", this.api.getGrantType());
            if (this.config.hasScope()) {
                request.getBodyParams().add("scope", this.config.getScope());
            }
        }
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override
    public Token getRequestToken() {
        throw new UnsupportedOperationException("Unsupported operation, please use 'getAuthorizationUrl' and redirect your users there");
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signRequest(Token accessToken, OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }

    @Override
    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(this.config);
    }

    @Override
    public void signAccessTokenRequest(Token accessToken, OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }
}

