/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maxkey.client.http.HttpVerb;
import org.maxkey.client.http.ParameterList;
import org.maxkey.client.http.RequestTuner;
import org.maxkey.client.http.Response;
import org.maxkey.client.oauth.exceptions.OAuthConnectionException;
import org.maxkey.client.oauth.exceptions.OAuthException;
import org.maxkey.client.utils.HttpsTrusts;
import org.maxkey.client.utils.JsonUtils;

public class Request {
    private static Log _log = LogFactory.getLog(Request.class);
    public static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static RequestTuner NOOP = new RequestTuner(){

        @Override
        public void tune(Request request) {
        }
    };
    private String url;
    private HttpVerb verb;
    private ParameterList querystringParams;
    private ParameterList bodyParams;
    private Map<String, String> headers;
    private String payload = null;
    private HttpURLConnection connection;
    private String charset;
    private byte[] bytePayload = null;
    private boolean connectionKeepAlive = false;
    private boolean followRedirects = true;
    private Long connectTimeout = null;
    private Long readTimeout = null;
    private String realm;

    public Request(HttpVerb verb, String url) {
        this.verb = verb;
        this.url = url;
        this.querystringParams = new ParameterList();
        this.bodyParams = new ParameterList();
        this.headers = new HashMap<String, String>();
    }

    public Response send(RequestTuner tuner) {
        try {
            this.createConnection();
            return this.doSend(tuner);
        }
        catch (Exception e) {
            throw new OAuthConnectionException(e);
        }
    }

    public Response send() {
        return this.send(NOOP);
    }

    private void createConnection() throws IOException {
        String completeUrl = this.getCompleteUrl();
        _log.debug((Object)("verb method : " + (Object)((Object)this.verb)));
        _log.debug((Object)("completeUrl : " + completeUrl));
        if (this.connection == null) {
            System.setProperty("http.keepAlive", this.connectionKeepAlive ? "true" : "false");
            this.connection = (HttpURLConnection)new URL(completeUrl).openConnection();
            if (completeUrl.trim().startsWith("https")) {
                HttpsTrusts.beforeConnection();
            }
            this.connection.setInstanceFollowRedirects(this.followRedirects);
        }
    }

    public String getCompleteUrl() {
        return this.querystringParams.appendTo(this.url);
    }

    Response doSend(RequestTuner tuner) throws IOException {
        this.connection.setRequestMethod(this.verb.name());
        if (this.connectTimeout != null) {
            this.connection.setConnectTimeout(this.connectTimeout.intValue());
        }
        if (this.readTimeout != null) {
            this.connection.setReadTimeout(this.readTimeout.intValue());
        }
        this.addHeaders(this.connection);
        if (this.verb.equals((Object)HttpVerb.PUT) || this.verb.equals((Object)HttpVerb.POST)) {
            this.addBody(this.connection, this.getByteBodyContents());
        }
        tuner.tune(this);
        return new Response(this.connection);
    }

    void addHeaders(HttpURLConnection conn) {
        for (String key : this.headers.keySet()) {
            conn.setRequestProperty(key, this.headers.get(key));
        }
    }

    void addBody(HttpURLConnection conn, byte[] content) throws IOException {
        conn.setRequestProperty(CONTENT_LENGTH, String.valueOf(content.length));
        if (conn.getRequestProperty(CONTENT_TYPE) == null) {
            conn.setRequestProperty(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        }
        conn.setDoOutput(true);
        conn.getOutputStream().write(content);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addBodyParameter(String key, String value) {
        this.bodyParams.add(key, value);
    }

    public void addQuerystringParameter(String key, String value) {
        this.querystringParams.add(key, value);
    }

    public void addParameter(String key, String value) {
        if (this.hasBodyContent()) {
            this.bodyParams.add(key, value);
        } else {
            this.querystringParams.add(key, value);
        }
    }

    protected boolean hasBodyContent() {
        return this.verb == HttpVerb.PUT || this.verb == HttpVerb.POST;
    }

    public void addPayload(String payload) {
        this.payload = payload;
    }

    public void addPayload(byte[] payload) {
        this.bytePayload = (byte[])payload.clone();
    }

    public void addRestContent(String content) {
        this.payload = content;
    }

    public void addRestObject(Object content) {
        try {
            this.bytePayload = JsonUtils.gson2Json(content).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void addRestContent(byte[] content) {
        this.bytePayload = (byte[])content.clone();
    }

    public ParameterList getQueryStringParams() {
        try {
            ParameterList result = new ParameterList();
            String queryString = new URL(this.url).getQuery();
            result.addQuerystring(queryString);
            result.addAll(this.querystringParams);
            return result;
        }
        catch (MalformedURLException mue) {
            throw new OAuthException("Malformed URL", mue);
        }
    }

    public ParameterList getBodyParams() {
        return this.bodyParams;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSanitizedUrl() {
        if (this.url.startsWith("http://") && (this.url.endsWith(":80") || this.url.contains(":80/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":80", "");
        }
        if (this.url.startsWith("https://") && (this.url.endsWith(":443") || this.url.contains(":443/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":443", "");
        }
        return this.url.replaceAll("\\?.*", "");
    }

    public String getBodyContents() {
        try {
            return new String(this.getByteBodyContents(), this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.charset, uee);
        }
    }

    byte[] getByteBodyContents() {
        if (this.bytePayload != null) {
            return this.bytePayload;
        }
        String body = this.payload != null ? this.payload : this.bodyParams.asFormUrlEncodedString();
        _log.debug((Object)("getByteBodyContents  : " + body));
        try {
            return body.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.getCharset(), uee);
        }
    }

    public HttpVerb getVerb() {
        return this.verb;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getCharset() {
        return this.charset == null ? Charset.defaultCharset().name() : this.charset;
    }

    public void setConnectTimeout(int duration, TimeUnit unit) {
        this.connectTimeout = unit.toMillis(duration);
    }

    public void setReadTimeout(int duration, TimeUnit unit) {
        this.readTimeout = unit.toMillis(duration);
    }

    public void setCharset(String charsetName) {
        this.charset = charsetName;
    }

    @Deprecated
    public void setConnectionKeepAlive(boolean connectionKeepAlive) {
        this.connectionKeepAlive = connectionKeepAlive;
    }

    public void setConnectionKeepAlive(String connectionKeepAlive) {
        System.setProperty("http.keepAlive", connectionKeepAlive);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }

    public String toString() {
        return String.format("@Request(%s %s)", new Object[]{this.getVerb(), this.getUrl()});
    }
}

