/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider.base;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.handler.SafeValueHandler;
import org.dromara.mybatis.jpa.metadata.ColumnMapper;
import org.dromara.mybatis.jpa.metadata.ColumnMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.builder.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.builder.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftDeleteProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(SoftDeleteProvider.class);

    public String softDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        ColumnMetadata.buildColumnMapper(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        StringBuilder keyValue = new StringBuilder();
        for (String value : idValues) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            keyValue.append(",'").append(SafeValueHandler.valueOf(value)).append("'");
            logger.trace("softDelete by id {}", (Object)value);
        }
        String keyValues = keyValue.substring(1).replace(";", "");
        ColumnMapper logicColumnMapper = ColumnMetadata.getLogicColumn(entityClass);
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        ColumnMapper partitionKeyColumnMapper = ColumnMetadata.getPartitionKey(entityClass);
        ColumnMapper idFieldColumnMapper = ColumnMetadata.getIdColumn(entityClass);
        SQL sql = (SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(" %s = '%s' ".formatted(logicColumnMapper.getColumn(), logicColumnMapper.getSoftDelete().delete()));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumn(), partitionKeyValue, idFieldColumnMapper.getColumn(), idFieldColumnMapper.getField()));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumn(), keyValues));
        }
        String deleteSql = sql.toString();
        logger.trace("softDelete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String softDeleteByQuery(Class<?> entityClass, Query query) {
        logger.trace("softDelete By Query \n{}", (Object)query);
        ColumnMetadata.buildColumnMapper(entityClass);
        ColumnMapper logicColumnMapper = ColumnMetadata.getLogicColumn(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(" %s = '%s' ".formatted(logicColumnMapper.getColumn(), logicColumnMapper.getSoftDelete().delete()))).WHERE(QueryBuilder.build(query));
        logger.trace("softDelete By Query  SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String softDeleteByLambdaQuery(Class<?> entityClass, LambdaQuery<T> lambdaQuery) {
        logger.trace("softDelete By LambdaQuery \n{}", lambdaQuery);
        ColumnMetadata.buildColumnMapper(entityClass);
        ColumnMapper logicColumnMapper = ColumnMetadata.getLogicColumn(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(" %s = '%s' ".formatted(logicColumnMapper.getColumn(), logicColumnMapper.getSoftDelete().delete()))).WHERE(LambdaQueryBuilder.build(lambdaQuery));
        logger.trace("softDelete By LambdaQuery  SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

