/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.velocity;

import javax.servlet.jsp.JspException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.taglibs.authz.AuthenticationTag;
import org.springframework.security.taglibs.authz.JspAuthorizeTag;
import org.springframework.security.taglibs.velocity.Authz;

public class AuthzImpl
implements Authz {
    static final int ALL_GRANTED = 1;
    static final int ANY_GRANTED = 2;
    static final int NONE_GRANTED = 3;
    private ApplicationContext appCtx;

    public boolean allGranted(String roles) {
        return this.ifGranted(roles, 1);
    }

    public boolean anyGranted(String roles) {
        return this.ifGranted(roles, 2);
    }

    public ApplicationContext getAppCtx() {
        return this.appCtx;
    }

    public String getPrincipal() {
        MyAuthenticationTag authenticationTag = new MyAuthenticationTag();
        authenticationTag.setProperty("name");
        try {
            authenticationTag.doEndTag();
        }
        catch (JspException je) {
            je.printStackTrace();
            throw new IllegalArgumentException(je.getMessage());
        }
        return authenticationTag.getLastMessage();
    }

    private boolean ifGranted(String roles, int grantType) {
        int result;
        JspAuthorizeTag authorizeTag = new JspAuthorizeTag();
        try {
            switch (grantType) {
                case 1: {
                    authorizeTag.setIfAllGranted(roles);
                    break;
                }
                case 2: {
                    authorizeTag.setIfAnyGranted(roles);
                    break;
                }
                case 3: {
                    authorizeTag.setIfNotGranted(roles);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid granted type : " + grantType + " role=" + roles);
                }
            }
            result = authorizeTag.doStartTag();
        }
        catch (JspException je) {
            throw new IllegalArgumentException(je.getMessage());
        }
        return 1 == result;
    }

    public boolean noneGranted(String roles) {
        return this.ifGranted(roles, 3);
    }

    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    private class MyAuthenticationTag
    extends AuthenticationTag {
        private static final long serialVersionUID = -1094246833893599161L;
        String lastMessage = null;

        private MyAuthenticationTag() {
        }

        public String getLastMessage() {
            return this.lastMessage;
        }

        protected void writeMessage(String msg) throws JspException {
            this.lastMessage = msg;
        }
    }
}

