/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.model;

import com.connsec.client.http.HttpVerb;
import com.connsec.client.http.Request;
import java.util.HashMap;
import java.util.Map;

public class OAuthRequest
extends Request {
    private static final String OAUTH_PREFIX = "oauth_";
    private Map<String, String> oauthParameters = new HashMap();

    public OAuthRequest(HttpVerb verb, String url) {
        super(verb, url);
    }

    public void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(this.checkKey(key), value);
    }

    public void addParameter(String key, String value) {
        this.oauthParameters.put(key, value);
    }

    private String checkKey(String key) {
        if (key.startsWith(OAUTH_PREFIX) || key.equals("scope")) {
            return key;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s' or start with '%s'", "scope", OAUTH_PREFIX));
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    public String toString() {
        return String.format("@OAuthRequest(%s, %s)", this.getVerb(), this.getUrl());
    }
}

