/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import javax.xml.namespace.QName;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractXMLObjectUnmarshaller
implements Unmarshaller {
    private final Logger log = LoggerFactory.getLogger(AbstractXMLObjectUnmarshaller.class);
    private QName targetQName;
    private XMLObjectBuilderFactory xmlObjectBuilderFactory;
    private UnmarshallerFactory unmarshallerFactory;

    protected AbstractXMLObjectUnmarshaller() {
        this.xmlObjectBuilderFactory = Configuration.getBuilderFactory();
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
    }

    protected AbstractXMLObjectUnmarshaller(String targetNamespaceURI, String targetLocalName) {
        this.targetQName = XMLHelper.constructQName(targetNamespaceURI, targetLocalName, null);
        this.xmlObjectBuilderFactory = Configuration.getBuilderFactory();
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
    }

    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        this.log.trace("Starting to unmarshall DOM element {}", (Object)XMLHelper.getNodeQName(domElement));
        this.checkElementIsTarget(domElement);
        XMLObject xmlObject = this.buildXMLObject(domElement);
        this.log.trace("Unmarshalling attributes of DOM Element {}", (Object)XMLHelper.getNodeQName(domElement));
        NamedNodeMap attributes = domElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() != 2) continue;
            this.unmarshallAttribute(xmlObject, (Attr)attribute);
        }
        this.log.trace("Unmarshalling other child nodes of DOM Element {}", (Object)XMLHelper.getNodeQName(domElement));
        NodeList childNodes = domElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 2) {
                this.unmarshallAttribute(xmlObject, (Attr)childNode);
                continue;
            }
            if (childNode.getNodeType() == 1) {
                this.unmarshallChildElement(xmlObject, (Element)childNode);
                continue;
            }
            if (childNode.getNodeType() != 3) continue;
            this.unmarshallTextContent(xmlObject, (Text)childNode);
        }
        xmlObject.setDOM(domElement);
        return xmlObject;
    }

    protected void checkElementIsTarget(Element domElement) throws UnmarshallingException {
        QName elementName = XMLHelper.getNodeQName(domElement);
        if (this.targetQName == null) {
            this.log.trace("Targeted QName checking is not available for this unmarshaller, DOM Element {} was not verified", (Object)elementName);
            return;
        }
        this.log.trace("Checking that {} meets target criteria.", (Object)elementName);
        QName type = XMLHelper.getXSIType(domElement);
        if (type != null && type.equals(this.targetQName)) {
            this.log.trace("{} schema type matches target.", (Object)elementName);
            return;
        }
        if (elementName.equals(this.targetQName)) {
            this.log.trace("{} element name matches target.", (Object)elementName);
            return;
        }
        String errorMsg = "This unmarshaller only operates on " + this.targetQName + " elements not " + elementName;
        this.log.error(errorMsg);
        throw new UnmarshallingException(errorMsg);
    }

    protected XMLObject buildXMLObject(Element domElement) throws UnmarshallingException {
        this.log.trace("Building XMLObject for {}", (Object)XMLHelper.getNodeQName(domElement));
        XMLObjectBuilder xmlObjectBuilder = this.xmlObjectBuilderFactory.getBuilder(domElement);
        if (xmlObjectBuilder == null) {
            xmlObjectBuilder = this.xmlObjectBuilderFactory.getBuilder(Configuration.getDefaultProviderQName());
            if (xmlObjectBuilder == null) {
                String errorMsg = "Unable to located builder for " + XMLHelper.getNodeQName(domElement);
                this.log.error(errorMsg);
                throw new UnmarshallingException(errorMsg);
            }
            this.log.trace("No builder was registered for {} but the default builder {} was available, using it.", (Object)XMLHelper.getNodeQName(domElement), (Object)xmlObjectBuilder.getClass().getName());
        }
        return xmlObjectBuilder.buildObject(domElement);
    }

    protected void unmarshallAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        this.log.trace("Pre-processing attribute {}", (Object)XMLHelper.getNodeQName(attribute));
        String attributeNamespace = DatatypeHelper.safeTrimOrNullString(attribute.getNamespaceURI());
        if (DatatypeHelper.safeEquals(attributeNamespace, "http://www.w3.org/2000/xmlns/")) {
            this.unmarshallNamespaceAttribute(xmlObject, attribute);
        } else if (DatatypeHelper.safeEquals(attributeNamespace, "http://www.w3.org/2001/XMLSchema-instance")) {
            this.unmarshallSchemaInstanceAttributes(xmlObject, attribute);
        } else {
            this.log.trace("Attribute {} is neither a schema type nor namespace, calling processAttribute()", (Object)XMLHelper.getNodeQName(attribute));
            String attributeNSURI = attribute.getNamespaceURI();
            if (attributeNSURI != null) {
                String attributeNSPrefix = attribute.lookupPrefix(attributeNSURI);
                Namespace attributeNS = new Namespace(attributeNSURI, attributeNSPrefix);
                attributeNS.setAlwaysDeclare(false);
                xmlObject.addNamespace(attributeNS);
            }
            this.checkIDAttribute(attribute);
            this.processAttribute(xmlObject, attribute);
        }
    }

    protected void unmarshallNamespaceAttribute(XMLObject xmlObject, Attr attribute) {
        this.log.trace("{} is a namespace declaration, adding it to the list of namespaces on the XMLObject", (Object)XMLHelper.getNodeQName(attribute));
        Namespace namespace = DatatypeHelper.safeEquals(attribute.getLocalName(), "xmlns") ? new Namespace(attribute.getValue(), null) : new Namespace(attribute.getValue(), attribute.getLocalName());
        namespace.setAlwaysDeclare(true);
        xmlObject.addNamespace(namespace);
    }

    protected void unmarshallSchemaInstanceAttributes(XMLObject xmlObject, Attr attribute) {
        if (!DatatypeHelper.safeEquals(attribute.getLocalName(), "type")) {
            if (DatatypeHelper.safeEquals(attribute.getLocalName(), "schemaLocation")) {
                xmlObject.setSchemaLocation(attribute.getValue());
            } else if (DatatypeHelper.safeEquals(attribute.getLocalName(), "noNamespaceSchemaLocation")) {
                xmlObject.setNoNamespaceSchemaLocation(attribute.getValue());
            }
        }
    }

    protected void checkIDAttribute(Attr attribute) {
        QName attribName = XMLHelper.getNodeQName(attribute);
        if (Configuration.isIDAttribute(attribName) && !attribute.isId()) {
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }

    protected void unmarshallChildElement(XMLObject xmlObject, Element childElement) throws UnmarshallingException {
        this.log.trace("Unmarshalling child elements of XMLObject {}", (Object)xmlObject.getElementQName());
        Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(childElement);
        if (unmarshaller == null) {
            unmarshaller = this.unmarshallerFactory.getUnmarshaller(Configuration.getDefaultProviderQName());
            if (unmarshaller == null) {
                String errorMsg = "No unmarshaller available for " + XMLHelper.getNodeQName(childElement) + ", child of " + xmlObject.getElementQName();
                this.log.error(errorMsg);
                throw new UnmarshallingException(errorMsg);
            }
            this.log.trace("No unmarshaller was registered for {}, child of {}. Using default unmarshaller.", (Object)XMLHelper.getNodeQName(childElement), (Object)xmlObject.getElementQName());
        }
        this.log.trace("Unmarshalling child element {}with unmarshaller {}", (Object)XMLHelper.getNodeQName(childElement), (Object)unmarshaller.getClass().getName());
        this.processChildElement(xmlObject, unmarshaller.unmarshall(childElement));
    }

    protected void unmarshallTextContent(XMLObject xmlObject, Text content) throws UnmarshallingException {
        String textContent = DatatypeHelper.safeTrimOrNullString(content.getWholeText());
        if (textContent != null) {
            this.processElementContent(xmlObject, textContent);
        }
    }

    protected abstract void processChildElement(XMLObject var1, XMLObject var2) throws UnmarshallingException;

    protected abstract void processAttribute(XMLObject var1, Attr var2) throws UnmarshallingException;

    protected abstract void processElementContent(XMLObject var1, String var2);
}

