/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.extractors;

import java.util.Map;
import org.maxkey.client.oauth.exceptions.OAuthParametersMissingException;
import org.maxkey.client.oauth.extractors.HeaderExtractor;
import org.maxkey.client.oauth.model.OAuthRequest;
import org.maxkey.client.utils.HttpEncoder;
import org.maxkey.client.utils.Preconditions;

public class HeaderExtractorImpl
implements HeaderExtractor {
    private static final String PARAM_SEPARATOR = ", ";
    private static final String PREAMBLE = "OAuth ";
    public static final int ESTIMATED_PARAM_LENGTH = 20;

    @Override
    public String extract(OAuthRequest request) {
        this.checkPreconditions(request);
        Map<String, String> parameters = request.getOauthParameters();
        StringBuilder header = new StringBuilder(parameters.size() * 20);
        header.append(PREAMBLE);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (header.length() > PREAMBLE.length()) {
                header.append(PARAM_SEPARATOR);
            }
            header.append(String.format("%s=\"%s\"", entry.getKey(), HttpEncoder.encode(entry.getValue())));
        }
        return header.toString();
    }

    private void checkPreconditions(OAuthRequest request) {
        Preconditions.checkNotNull(request, "Cannot extract a header from a null object");
        if (request.getOauthParameters() == null || request.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(request);
        }
    }
}

