/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.extractors;

import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.utils.HttpEncoder;
import com.connsec.client.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenExtractor20Impl
implements AccessTokenExtractor {
    private static final String TOKEN_REGEX = "access_token=([^&]+)";
    private static final String EMPTY_SECRET = "";

    public Token extract(String response) {
        Preconditions.checkEmptyString((String)response, (String)"Response body is incorrect. Can't extract a token from an empty string");
        Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
        if (matcher.find()) {
            try {
                String token = HttpEncoder.decode((String)matcher.group(1));
                return new Token(token, EMPTY_SECRET, response);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
    }
}

