/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.extractors;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.maxkey.client.oauth.exceptions.OAuthException;
import org.maxkey.client.oauth.extractors.AccessTokenExtractor;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.utils.Preconditions;

public class QQTokenExtractor
implements AccessTokenExtractor {
    static final Logger log = Logger.getLogger(QQTokenExtractor.class);

    @Override
    public Token extract(String response) {
        log.debug((Object)("extract a token from : " + response));
        Preconditions.checkEmptyString(response, "Cannot extract a token from a null or empty String");
        try {
            String[] fields = response.split("&");
            HashMap<String, Object> tokenMap = new HashMap<String, Object>();
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                String[] sfield = field.split("=");
                if (sfield.length == 2) {
                    tokenMap.put(sfield[0], sfield[1]);
                }
                ++n2;
            }
            log.debug((Object)("token map : " + tokenMap));
            Token token = new Token(tokenMap.get("access_token").toString(), "", response, tokenMap);
            return token;
        }
        catch (Exception e) {
            throw new OAuthException("Cannot extract an acces token. Response was: " + response);
        }
    }
}

