/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider.base;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.ColumnMapper;
import org.dromara.mybatis.jpa.metadata.ColumnMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.builder.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.builder.QueryBuilder;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(FetchProvider.class);

    public String fetch(Map<String, Object> parametersMap) {
        JpaEntity entity = (JpaEntity)parametersMap.get("entity");
        List<ColumnMapper> listFields = ColumnMetadata.buildColumnMapper(entity.getClass());
        String[] column = new String[listFields.size()];
        StringBuilder conditions = new StringBuilder();
        int columnCount = 0;
        for (ColumnMapper fieldColumnMapper : listFields) {
            String columnName = fieldColumnMapper.getColumn();
            String fieldName = fieldColumnMapper.getField();
            String fieldType = fieldColumnMapper.getFieldType();
            Object fieldValue = BeanUtil.getValue(entity, fieldName);
            column[columnCount++] = columnName;
            boolean isFieldValueNull = BeanUtil.isFieldBlank(fieldValue);
            if (isFieldValueNull || fieldType.startsWith("byte")) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Field {} , Type {} , Value is null , Skiped ", (Object)String.format("%-30s", fieldName), (Object)String.format("%-30s", fieldType));
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Field {} , Type {} , Value {}", new Object[]{String.format("%-30s", fieldName), String.format("%-30s", fieldType), fieldValue});
            }
            if (!conditions.isEmpty()) {
                conditions.append(" and ");
            }
            if (fieldColumnMapper.isLogicDelete()) {
                conditions.append(" %s = '%s' ".formatted(columnName, fieldColumnMapper.getSoftDelete().value()));
                continue;
            }
            conditions.append(" %s = #{%s.%s} ".formatted(columnName, "entity", fieldName));
        }
        SQL sql = (SQL)((SQL)((SQL)new SQL().SELECT(column)).FROM(TableMetadata.getTableName(entity.getClass()))).WHERE(conditions.toString());
        logger.trace("Query Page SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    public String fetchByQuery(Map<String, Object> parametersMap) {
        ColumnMapper logicColumnMapper;
        Class entityClass = (Class)parametersMap.get("entityClass");
        Query condition = (Query)parametersMap.get("condition");
        List<ColumnMapper> listFields = ColumnMetadata.buildColumnMapper(entityClass);
        String[] column = new String[listFields.size()];
        for (int i = 0; i < listFields.size(); ++i) {
            column[i] = listFields.get(i).getColumn();
        }
        SQL sql = (SQL)((SQL)new SQL().SELECT(column)).FROM(TableMetadata.getTableName(entityClass));
        String conditionString = QueryBuilder.build(condition);
        if (StringUtils.isNotBlank((CharSequence)conditionString)) {
            sql.WHERE("( " + conditionString + " ) ");
        }
        if ((logicColumnMapper = ColumnMetadata.getLogicColumn(entityClass)) != null && logicColumnMapper.isLogicDelete() && condition.isSoftDelete()) {
            sql.WHERE(" ( %s = '%s' )".formatted(logicColumnMapper.getColumn(), logicColumnMapper.getSoftDelete().value()));
        }
        logger.trace("query Page By Query SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    public String fetchByLambdaQuery(Map<String, Object> parametersMap) {
        ColumnMapper logicColumnMapper;
        Class entityClass = (Class)parametersMap.get("entityClass");
        LambdaQuery condition = (LambdaQuery)parametersMap.get("condition");
        List<ColumnMapper> listFields = ColumnMetadata.buildColumnMapper(entityClass);
        String[] column = new String[listFields.size()];
        for (int i = 0; i < listFields.size(); ++i) {
            column[i] = listFields.get(i).getColumn();
        }
        SQL sql = (SQL)((SQL)new SQL().SELECT(column)).FROM(TableMetadata.getTableName(entityClass));
        String conditionString = LambdaQueryBuilder.build(condition);
        if (StringUtils.isNotBlank((CharSequence)conditionString)) {
            sql.WHERE("( " + conditionString + " ) ");
        }
        if ((logicColumnMapper = ColumnMetadata.getLogicColumn(entityClass)) != null && logicColumnMapper.isLogicDelete() && condition.isSoftDelete()) {
            sql.WHERE(" ( %s = '%s' )".formatted(logicColumnMapper.getColumn(), logicColumnMapper.getSoftDelete().value()));
        }
        logger.trace("query Page By LambdaQuery SQL : \n{}", (Object)sql);
        return sql.toString();
    }
}

