/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NodeArray
extends AbstractList
implements List,
NodeList {
    public static final Node[] emptyNodes = new Node[0];
    public Node[] nodes = emptyNodes;
    public int len = 0;

    public NodeArray() {
    }

    public NodeArray(NodeList nl) {
        this();
        this.addNodes(nl);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.nodes.length) {
            if (capacity < this.nodes.length * 2) {
                capacity = this.nodes.length * 2;
            }
            if (capacity < 64) {
                capacity = 64;
            }
            Node[] newNodes = new Node[capacity];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.len);
            this.nodes = newNodes;
        }
    }

    public void addNodes(NodeList nl) {
        if (nl instanceof NodeArray) {
            NodeArray na = (NodeArray)nl;
            this.ensureCapacity(this.len + na.len);
            System.arraycopy(na.nodes, 0, this.nodes, this.len, na.len);
            this.len += na.len;
        } else {
            int l = nl.getLength();
            this.ensureCapacity(this.len + l);
            for (int i = 0; i < l; ++i) {
                this.nodes[this.len + i] = nl.item(i);
            }
            this.len += l;
        }
    }

    public void truncate(int length) {
        if (length < this.len) {
            Arrays.fill(this.nodes, length, this.len, null);
            this.len = length;
        }
        ++this.modCount;
    }

    public Node item(int index) {
        if (index < 0 || index > this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.nodes[index];
    }

    public int getLength() {
        return this.len;
    }

    public Object get(int index) {
        return this.item(index);
    }

    public int size() {
        return this.len;
    }

    public boolean add(Object node) {
        this.ensureCapacity(this.len + 1);
        this.nodes[this.len++] = (Node)node;
        ++this.modCount;
        return true;
    }

    public boolean addAll(Collection c) {
        this.ensureCapacity(this.len + c.size());
        return super.addAll(c);
    }

    public void clear() {
        this.truncate(0);
    }
}

