/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import java.util.Iterator;
import org.apache.tsik.xpath.Context;
import org.apache.tsik.xpath.evaluator.ContextImpl;
import org.apache.tsik.xpath.evaluator.ExprEvaluator;
import org.apache.tsik.xpath.util.Coerce;
import org.apache.tsik.xpath.util.NodeSet;
import org.w3c.dom.Node;

public class PredicateExprEvaluator
extends ExprEvaluator {
    private ExprEvaluator sourceExpr;
    private ExprEvaluator predicateExpr;

    public PredicateExprEvaluator(ExprEvaluator sourceExpr, ExprEvaluator predicateExpr) {
        this.sourceExpr = sourceExpr;
        this.predicateExpr = predicateExpr;
    }

    public int getPrecedence() {
        return 100;
    }

    public boolean isConstant() {
        return this.sourceExpr.isConstant() && this.predicateExpr.isConstant();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.sourceExpr.getPrecedence() < this.getPrecedence()) {
            sb.append("(");
            sb.append(this.sourceExpr.toString());
            sb.append(")");
        } else {
            sb.append(this.sourceExpr.toString());
        }
        sb.append("[");
        sb.append(this.predicateExpr);
        sb.append("]");
        return sb.toString();
    }

    public Object evaluate(Context context) {
        int l;
        Object source = this.sourceExpr.evaluate(context);
        NodeSet ns = (NodeSet)source;
        NodeSet nns = new NodeSet();
        ContextImpl predicateContext = new ContextImpl((ContextImpl)context);
        predicateContext.size = l = ns.size();
        Iterator it = ns.iterator();
        predicateContext.position = 0;
        while (it.hasNext()) {
            predicateContext.node = (Node)it.next();
            ++predicateContext.position;
            Object predicateValue = this.predicateExpr.evaluate(predicateContext);
            if (predicateValue instanceof Number) {
                predicateValue = new Boolean(((Number)predicateValue).doubleValue() == (double)predicateContext.position);
            }
            if (!Coerce.toBoolean(predicateValue).booleanValue()) continue;
            nns.add(predicateContext.node);
        }
        return nns;
    }
}

