/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import org.apache.tsik.xpath.evaluator.ContextImpl;
import org.apache.tsik.xpath.evaluator.Evaluator;
import org.apache.tsik.xpath.evaluator.ExprEvaluator;
import org.apache.tsik.xpath.evaluator.InvocationContext;
import org.apache.tsik.xpath.util.Coerce;
import org.apache.tsik.xpath.util.NodeArray;

public class PredicateEvaluator
extends Evaluator {
    private ExprEvaluator predicate;

    public PredicateEvaluator(ExprEvaluator predicate) {
        this.predicate = predicate;
    }

    public void filter(InvocationContext invocationContext, NodeArray na, boolean isReverseAxis) {
        ContextImpl predicateContext = new ContextImpl();
        predicateContext.size = na.len;
        predicateContext.invocation = invocationContext;
        int j = 0;
        int l = na.len;
        for (int i = 0; i < l; ++i) {
            predicateContext.position = isReverseAxis ? l - i : i + 1;
            predicateContext.node = na.nodes[i];
            Object predicateValue = this.predicate.evaluate(predicateContext);
            if (predicateValue instanceof Number) {
                predicateValue = new Boolean(((Number)predicateValue).doubleValue() == (double)predicateContext.position);
            }
            if (!Coerce.toBoolean(predicateValue).booleanValue()) continue;
            na.nodes[j++] = predicateContext.node;
        }
        na.truncate(j);
    }

    public String toString() {
        return "[" + this.predicate.toString() + "]";
    }
}

