/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tsik.xpath.BindingContext;
import org.apache.tsik.xpath.Context;
import org.apache.tsik.xpath.Function;
import org.apache.tsik.xpath.evaluator.ExprEvaluator;
import org.apache.tsik.xpath.util.QualifiedName;

public class FunctionCallExprEvaluator
extends ExprEvaluator {
    private QualifiedName functionName;
    private ArrayList argumentExprs;

    public FunctionCallExprEvaluator(QualifiedName functionName) {
        this.functionName = functionName;
        this.argumentExprs = new ArrayList();
    }

    public void addArgument(ExprEvaluator arg) {
        this.argumentExprs.add(arg);
    }

    public Object evaluate(Context context) {
        BindingContext bc = context.getBindingContext();
        Function func = bc.getFunction(bc.getNamespaceURI(this.functionName.getPrefix()), this.functionName.getLocalName());
        if (func == null) {
            throw new IllegalArgumentException("function not defined: " + this.functionName.getPrefix() + ':' + this.functionName.getLocalName());
        }
        ArrayList<Object> args = new ArrayList<Object>(this.argumentExprs.size());
        Iterator it = this.argumentExprs.iterator();
        while (it.hasNext()) {
            ExprEvaluator ev = (ExprEvaluator)it.next();
            args.add(ev.evaluate(context));
        }
        return func.evaluate(context, args);
    }

    public int getPrecedence() {
        return Integer.MAX_VALUE;
    }

    public boolean isConstant() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.functionName.toString());
        sb.append("(");
        Iterator i = this.argumentExprs.iterator();
        if (i.hasNext()) {
            sb.append(i.next().toString());
        }
        while (i.hasNext()) {
            sb.append(", ");
            sb.append(i.next().toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

