/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;

public class DigestValue
extends ElementImpl {
    private static String name = "DigestValue";
    private static String prefix = Namespaces.XMLSIG.getPrefix();
    private static String uri = Namespaces.XMLSIG.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private static boolean DEBUG = false;
    private String base64;

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        wc.setText(this.base64);
    }

    public static DigestValue fromXml(DOMCursor cursor) {
        DOMCursor cc = DigestValue.placeCursor(cursor, name, prefix, uri, ns);
        String base64 = cc.getText();
        return new DigestValue(base64);
    }

    private DigestValue(String base64) {
        this.base64 = base64;
    }

    protected DigestValue() {
    }

    public byte[] getBytes() {
        return Base64.decode(this.base64);
    }

    public void set(byte[] b) {
        this.base64 = Base64.encode(b);
    }

    public void set(String base64) {
        this.base64 = base64;
    }

    public String toString() {
        String s = "[DigestValue ";
        s = s + this.base64.substring(0, 10) + "...";
        return s + "]";
    }
}

