/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.xmlsig.DSAVerifyingKey;
import org.apache.tsik.xmlsig.RSAVerifyingKey;
import org.apache.tsik.xmlsig.VerifyingKey;
import org.apache.tsik.xmlsig.elements.KeyInfo;
import org.apache.tsik.xmlsig.elements.KeyValue;
import org.apache.tsik.xmlsig.elements.Signature;
import org.apache.tsik.xmlsig.elements.SignedInfo;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Verifier {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$Verifier == null ? (class$org$apache$tsik$xmlsig$Verifier = Verifier.class$("org.apache.tsik.xmlsig.Verifier")) : class$org$apache$tsik$xmlsig$Verifier);
    private DOMCursor cursor;
    private Signature signature;
    private byte[] canon;
    private long canonTime = 0L;
    private long cursorTime = 0L;
    private long moveTime = 0L;
    private long fromXmlTime = 0L;
    private VerifyingKey verifyingKey = null;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$Verifier;

    public Verifier(Document doc, XPath signatureLocation) throws XPathException, NoSuchAlgorithmException {
        boolean doTimes = log.isDebugEnabled();
        if (doc == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        if (signatureLocation == null) {
            throw new IllegalArgumentException("signature location cannot be null");
        }
        long t = 0L;
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.cursor = new DOMCursor(doc);
        if (doTimes) {
            this.cursorTime = System.currentTimeMillis() - t;
            t = System.currentTimeMillis();
        }
        this.cursor = this.moveCursor(this.cursor, signatureLocation);
        if (doTimes) {
            this.moveTime = System.currentTimeMillis() - t;
        }
        try {
            if (doTimes) {
                t = System.currentTimeMillis();
            }
            this.signature = Signature.fromXml(this.cursor);
            if (doTimes) {
                this.fromXmlTime = System.currentTimeMillis() - t;
            }
        }
        catch (ElementException e) {
            throw new IllegalArgumentException(e.toString());
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.canon = signedInfo.canonicalizeExisting(this.cursor);
        if (doTimes) {
            this.canonTime = System.currentTimeMillis() - t;
        }
    }

    private DOMCursor moveCursor(DOMCursor cursor, XPath xp) throws XPathException {
        if (!cursor.moveToXPath(xp) || !"Signature".equals(cursor.getLocalName())) {
            throw new XPathException("XPath expression '" + xp.getXPath() + "'" + " does not evaluate to " + Signature.uri + ":" + "Signature");
        }
        return cursor;
    }

    public boolean verify() throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        PublicKey publicKey = this.getVerifyingKey();
        if (publicKey == null) {
            throw new InvalidKeyException("No verification key set");
        }
        return this.verify(publicKey);
    }

    public boolean verify(PublicKey pubKey) throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        if (pubKey == null) {
            throw new InvalidKeyException("No verification key set");
        }
        this.verifyingKey = this.createVerifyingKey(pubKey);
        this.signature.setVerifyingKey(this.verifyingKey);
        return this.internalVerify();
    }

    public boolean verify(VerifyingKey verKey) throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        if (verKey == null) {
            throw new InvalidKeyException("No verification key set");
        }
        this.verifyingKey = verKey;
        this.signature.setVerifyingKey(this.verifyingKey);
        return this.internalVerify();
    }

    private boolean internalVerify() throws InvalidKeyException, XPathException, NoSuchAlgorithmException, SignatureException {
        SignedInfo signedInfo;
        boolean doTimes = log.isDebugEnabled();
        DOMCursor c = this.cursor.cloneCursor();
        String[] ns = new String[]{"ds", "http://www.w3.org/2000/09/xmldsig#"};
        XPath xp = new XPath("./ds:KeyInfo", ns);
        if (c.moveToXPath(xp)) {
            this.verifyingKey.readKeyInfo(c.getElement());
        }
        if (!(signedInfo = this.signature.getSignedInfo()).verifyReferences()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("canonical form = " + new String(this.canon));
        }
        long startTime = 0L;
        if (doTimes) {
            startTime = System.currentTimeMillis();
        }
        boolean b = this.signature.verifySignature(this.canon);
        if (doTimes) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.debug("Time to verify: " + (elapsedTime + this.canonTime + this.cursorTime + this.moveTime + this.fromXmlTime) + " ms, of which c14n: " + this.canonTime + " curs:" + this.cursorTime + " move: " + this.moveTime + " fromXml: " + this.fromXmlTime);
        }
        return b;
    }

    public boolean isReferenced(XPath xpath) {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        return signedInfo.isReferenced(xpath);
    }

    public Element[] getReferencedElements() {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        return signedInfo.getReferencedElements();
    }

    /*
     * WARNING - void declaration
     */
    private VerifyingKey createVerifyingKey(PublicKey verifyingKey) throws InvalidKeyException {
        void var2_2;
        VerifyingKey verKey;
        if (verifyingKey instanceof RSAPublicKey) {
            verKey = new RSAVerifyingKey(verifyingKey);
        } else if (verifyingKey instanceof DSAPublicKey) {
            verKey = new DSAVerifyingKey(verifyingKey);
        } else {
            throw new IllegalArgumentException("unknown signing key type");
        }
        return var2_2;
    }

    public PublicKey getVerifyingKey() throws XPathException, InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = this.internalGetVerifyingKey();
        X509Certificate cert = this.internalGetCertificate();
        if (cert == null) {
            return publicKey;
        }
        if (this.compare(cert, publicKey) != null) {
            return publicKey;
        }
        return null;
    }

    private PublicKey internalGetVerifyingKey() throws XPathException, InvalidKeyException, NoSuchAlgorithmException {
        KeyInfo keyInfo = this.signature.getKeyInfo();
        KeyValue keyValue = keyInfo.getKeyValue();
        if (keyValue == null) {
            throw new InvalidKeyException("No verifying key available");
        }
        VerifyingKey r = keyValue.generateVerifyingKey();
        if (r instanceof RSAVerifyingKey) {
            return ((RSAVerifyingKey)r).getPublicKey();
        }
        if (r instanceof DSAVerifyingKey) {
            return ((DSAVerifyingKey)r).getPublicKey();
        }
        return null;
    }

    public X509Certificate getCertificate() throws XPathException {
        PublicKey publicKey = null;
        try {
            publicKey = this.internalGetVerifyingKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.compare(this.internalGetCertificate(), publicKey);
    }

    private X509Certificate compare(X509Certificate cert, PublicKey publicKey) {
        if (cert == null || publicKey == null) {
            return cert;
        }
        if (!Arrays.equals(publicKey.getEncoded(), cert.getPublicKey().getEncoded())) {
            log.warn("Certificate's key differs from key in KeyInfo");
            return null;
        }
        return cert;
    }

    private X509Certificate internalGetCertificate() throws XPathException {
        KeyInfo keyInfo = this.signature.getKeyInfo();
        return keyInfo.getCertificate();
    }

    public X509Certificate[] getCertificateChain() throws XPathException {
        KeyInfo keyInfo = this.signature.getKeyInfo();
        X509Certificate[] certs = keyInfo.getCertificateChain();
        if (certs == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            publicKey = this.internalGetVerifyingKey();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.compare(certs[0], publicKey) != null) {
            return certs;
        }
        log.warn("Leaf certificate's key differs from key in KeyInfo");
        return null;
    }

    public org.apache.tsik.xmlsig.KeyInfo getKeyInfo() {
        KeyInfo keyInfo = this.signature.getKeyInfo();
        if (keyInfo != null) {
            return keyInfo.getKeyInfo();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

