/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.apache.tsik.xmlsig.DSASigningKey;
import org.apache.tsik.xmlsig.RSASigningKey;
import org.apache.tsik.xmlsig.SigningKey;

public class SigningKeyFactory {
    private SigningKeyFactory() {
    }

    public static SigningKey makeSigningKey(Key key) throws GeneralSecurityException {
        if (key instanceof RSAPrivateKey) {
            return new RSASigningKey((PrivateKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return new DSASigningKey((PrivateKey)key);
        }
        return null;
    }
}

