/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.math.BigInteger;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;

final class Asn1 {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$Asn1 == null ? (class$org$apache$tsik$xmlsig$Asn1 = Asn1.class$("org.apache.tsik.xmlsig.Asn1")) : class$org$apache$tsik$xmlsig$Asn1);
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$Asn1;

    private Asn1() {
    }

    static byte[] derEncode(byte[] r, byte[] s) {
        byte[] derR = new byte[r.length + 2];
        derR[0] = 2;
        derR[1] = (byte)r.length;
        System.arraycopy(r, 0, derR, 2, r.length);
        byte[] derS = new byte[s.length + 2];
        derS[0] = 2;
        derS[1] = (byte)s.length;
        System.arraycopy(s, 0, derS, 2, s.length);
        byte[] b = new byte[2 + derR.length + derS.length];
        b[0] = 48;
        b[1] = (byte)(b.length - 2);
        System.arraycopy(derR, 0, b, 2, derR.length);
        System.arraycopy(derS, 0, b, 2 + derR.length, derS.length);
        return b;
    }

    static boolean isDerEncodedSequence(byte[] a) {
        if (a == null || a.length < 3) {
            return false;
        }
        return a[0] == 48 && a[2] == 2 && a[1] == a.length - 2;
    }

    static byte[] os2ip(byte[] v) {
        return new BigInteger(1, v).toByteArray();
    }

    static byte[] convertToRfc2437(byte[] signatureValue) {
        if (!Asn1.isDerEncodedSequence(signatureValue)) {
            return signatureValue;
        }
        int start = 4;
        byte len = signatureValue[start - 1];
        byte[] data = new byte[len];
        System.arraycopy(signatureValue, start, data, 0, len);
        byte[] r = Asn1.fit(data, 20);
        start += len + 2;
        len = signatureValue[start - 1];
        data = new byte[len];
        System.arraycopy(signatureValue, start, data, 0, len);
        byte[] s = Asn1.fit(data, 20);
        byte[] b = new byte[40];
        System.arraycopy(r, 0, b, 0, 20);
        System.arraycopy(s, 0, b, 20, 20);
        return b;
    }

    private static byte[] fit(byte[] b, int length) {
        int offset;
        int len = b.length;
        int n = offset = b[0] == 0 ? 1 : 0;
        if ((len -= offset) > length) {
            log.error("Internal error: DSA value too large to fit into " + length + " bytes");
            len = length;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(b, offset, bytes, length - len, len);
        return bytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

