/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc.elements;

import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.Element;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlenc.AlgorithmType;

public class EncryptionMethod
extends ElementImpl {
    private static String name = "EncryptionMethod";
    private static String algorithmAttributeName = "Algorithm";
    private static String prefix = Namespaces.XMLENC.getPrefix();
    private static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private AlgorithmType type = null;

    public static Element fromXml(DOMCursor c) {
        DOMCursor cc = EncryptionMethod.placeCursor(c, name, prefix, uri, ns);
        String uri = cc.getAttribute(algorithmAttributeName);
        EncryptionMethod e = new EncryptionMethod();
        AlgorithmType type = AlgorithmType.getInstance(uri);
        if (type == null) {
            throw new UnsupportedOperationException("Algorithm " + uri + " is not supported");
        }
        e.setAlgorithmType(type);
        return e;
    }

    public void setAlgorithmType(AlgorithmType type) {
        this.type = type;
    }

    public AlgorithmType getAlgorithmType() {
        return this.type;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.type != null) {
            wc.setAttribute(algorithmAttributeName, this.type.getUri());
        }
    }
}

