/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import java.util.ArrayList;
import org.apache.tsik.xml.schema.ModelGroup;
import org.apache.tsik.xml.schema.Particle;
import org.apache.tsik.xml.schema.loader.ParticleImpl;
import org.apache.tsik.xml.schema.loader.SchemaComponentBase;
import org.apache.tsik.xml.schema.loader.SchemaImpl;
import org.w3c.dom.Element;

class ModelGroupImpl
extends SchemaComponentBase
implements ModelGroup {
    private short compositor;
    private ArrayList particles = new ArrayList();

    ModelGroupImpl(Element declaration, SchemaImpl schema) {
        super(declaration, schema);
    }

    ModelGroupImpl(SchemaImpl schema, short newCompositor) {
        this(null, schema);
        this.compositor = newCompositor;
    }

    public short getTermType() {
        return 1;
    }

    public short getCompositor() {
        return this.compositor;
    }

    public int getLength() {
        return this.particles.size();
    }

    public Particle getItem(int index) {
        return (Particle)this.particles.get(index);
    }

    void addItem(Particle part) {
        this.particles.add(part);
    }

    void readDefinition() {
        if (ops.matchName(this.declaration, this.schema.NS_XS, "sequence")) {
            this.compositor = 1;
        } else if (ops.matchName(this.declaration, this.schema.NS_XS, "choice")) {
            this.compositor = (short)2;
        } else if (ops.matchName(this.declaration, this.schema.NS_XS, "all")) {
            this.compositor = (short)3;
        }
        Element e = ops.firstElementChild(this.declaration);
        if (e != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        while (e != null) {
            ParticleImpl part = new ParticleImpl(e, this.schema);
            part.readDefinition();
            if (part.getMinOccurs() != 0 || part.getMaxOccurs() != 0) {
                this.particles.add(part);
            }
            e = ops.nextElementSibling(e);
        }
    }
}

