/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import org.apache.tsik.xml.schema.AttributeGroup;
import org.apache.tsik.xml.schema.ComplexType;
import org.apache.tsik.xml.schema.ModelGroup;
import org.apache.tsik.xml.schema.Particle;
import org.apache.tsik.xml.schema.SimpleType;
import org.apache.tsik.xml.schema.Term;
import org.apache.tsik.xml.schema.loader.AttributeGroupImpl;
import org.apache.tsik.xml.schema.loader.ModelGroupImpl;
import org.apache.tsik.xml.schema.loader.ParticleImpl;
import org.apache.tsik.xml.schema.loader.SchemaImpl;
import org.apache.tsik.xml.schema.loader.SimpleTypeImpl;
import org.apache.tsik.xml.schema.loader.TypeImpl;
import org.w3c.dom.Element;

class ComplexTypeImpl
extends TypeImpl
implements ComplexType {
    private short derivationMethod;
    private boolean isAbstract;
    private short prohibitedDerivationMethods;
    private short prohibitedSubstitutionMethods;
    private short contentMode;
    private SimpleType simpleContentType;
    private ParticleImpl contentParticle;
    private AttributeGroupImpl attributes;

    ComplexTypeImpl(Element declaration, String namespaceURI, String localName, SchemaImpl schema) {
        super(declaration, namespaceURI, localName, schema);
    }

    public boolean isComplexType() {
        return true;
    }

    public short getDerivationMethod() {
        return this.derivationMethod;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal(short derivationMethod) {
        return (this.prohibitedDerivationMethods & derivationMethod) != 0;
    }

    public boolean isProhibitedSubstitution(short derivationMethod) {
        return (this.prohibitedSubstitutionMethods & derivationMethod) != 0;
    }

    public short getContentMode() {
        return this.contentMode;
    }

    public SimpleType getSimpleContentType() {
        return this.simpleContentType;
    }

    public Particle getContentParticle() {
        return this.contentParticle;
    }

    public AttributeGroup getAttributes() {
        return this.attributes;
    }

    void readDefinition() {
        this.isAbstract = "true".equals(this.declaration.getAttribute("abstract"));
        this.prohibitedSubstitutionMethods = this.parseDerivationMethods(this.declaration, "block", "blockDefault", 3);
        this.prohibitedDerivationMethods = this.parseDerivationMethods(this.declaration, "final", "finalDefault", 3);
        Element e = ops.firstElementChild(this.declaration);
        if (e != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        if (e == null) {
            this.derivationMethod = (short)2;
            this.contentMode = 1;
            this.attributes = new AttributeGroupImpl(this.schema, null);
        } else if (ops.matchName(e, this.schema.NS_XS, "simpleContent")) {
            this.parseSimpleContent(this.declaration, e);
        } else if (ops.matchName(e, this.schema.NS_XS, "complexContent")) {
            this.parseComplexContent(this.declaration, e);
        } else {
            this.parseImpliedComplexRestriction(this.declaration, e);
        }
    }

    private void parseSimpleContent(Element complexType, Element simpleContent) {
        Element e = ops.firstElementChild(simpleContent);
        if (ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        if (ops.matchName(e, this.schema.NS_XS, "restriction")) {
            this.parseSimpleRestriction(complexType, simpleContent, e);
        } else if (ops.matchName(e, this.schema.NS_XS, "extension")) {
            this.parseSimpleExtension(complexType, simpleContent, e);
        }
        this.contentMode = (short)2;
    }

    private void parseSimpleRestriction(Element complexType, Element complexContent, Element restriction) {
        this.derivationMethod = (short)2;
        this.parseSimpleBaseType(restriction, false);
        SimpleTypeImpl stype = (SimpleTypeImpl)this.simpleContentType;
        Element e = ops.firstElementChild(restriction);
        if (e != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        if (e != null && ops.matchName(e, this.schema.NS_XS, "simpleType")) {
            stype = new SimpleTypeImpl(e, null, null, this.schema);
            stype.readDefinition();
            this.simpleContentType = stype;
            e = ops.nextElementSibling(e);
        }
        this.attributes = new AttributeGroupImpl(e, this.schema);
        this.attributes.readDefinition();
        if (this.baseType.isComplexType()) {
            ComplexType cbase = (ComplexType)this.baseType;
            this.attributes.unionAttributes(cbase.getAttributes());
            this.attributes.subtractProhibitedAttributes();
            SimpleTypeImpl sbase = stype;
            stype = new SimpleTypeImpl(this.schema);
            stype.parseRestriction(e, sbase);
            this.simpleContentType = stype;
        } else if (this.attributes.getLength() > 0) {
            this.error(null, "restriction attributes must extend complex base type", complexType);
        }
    }

    private void parseSimpleExtension(Element complexType, Element complexContent, Element extension) {
        this.derivationMethod = 1;
        this.parseSimpleBaseType(extension, true);
        Element e = ops.firstElementChild(extension);
        if (e != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        this.attributes = new AttributeGroupImpl(e, this.schema);
        this.attributes.readDefinition();
        if (this.baseType.isComplexType()) {
            ComplexType cbase = (ComplexType)this.baseType;
            AttributeGroup baseAttributes = cbase.getAttributes();
            this.attributes.unionAttributes(baseAttributes);
            if (this.attributes.getWildcard() == null) {
                this.attributes.setWildcard(baseAttributes.getWildcard());
            }
        }
    }

    private void parseComplexContent(Element complexType, Element complexContent) {
        Element e = ops.firstElementChild(complexContent);
        if (ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        if (ops.matchName(e, this.schema.NS_XS, "restriction")) {
            this.parseComplexRestriction(complexType, complexContent, e);
        } else if (ops.matchName(e, this.schema.NS_XS, "extension")) {
            this.parseComplexExtension(complexType, complexContent, e);
        }
    }

    private void parseComplexRestriction(Element complexType, Element complexContent, Element restriction) {
        this.derivationMethod = (short)2;
        this.parseComplexBaseType(restriction);
        ComplexType cbase = (ComplexType)this.baseType;
        Element e = ops.firstElementChild(restriction);
        if (e != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        this.parseComplexChildren(e);
        if (this.contentParticle == null) {
            this.contentMode = 1;
        } else {
            this.contentMode = (short)3;
            String attr = complexContent.getAttribute("mixed");
            if (attr.length() > 0) {
                if (attr.equals("true")) {
                    this.contentMode = (short)4;
                }
            } else if ("true".equals(complexType.getAttribute("mixed"))) {
                this.contentMode = (short)4;
            }
        }
        this.attributes.unionAttributes(cbase.getAttributes());
        this.attributes.subtractProhibitedAttributes();
    }

    private void parseImpliedComplexRestriction(Element complexType, Element child) {
        this.derivationMethod = (short)2;
        this.baseType = this.schema.getAnyType();
        ComplexType cbase = (ComplexType)this.baseType;
        this.parseComplexChildren(child);
        this.contentMode = this.contentParticle == null ? (short)1 : ("true".equals(complexType.getAttribute("mixed")) ? (short)4 : (short)3);
        this.attributes.unionAttributes(cbase.getAttributes());
        this.attributes.subtractProhibitedAttributes();
    }

    private void parseComplexChildren(Element child) {
        ModelGroup group;
        Term term;
        if (child != null) {
            if (ops.matchName(child, this.schema.NS_XS, "group")) {
                String ref = child.getAttribute("ref");
                if (ref.length() == 0) {
                    this.error(null, "nested <group> must have ref", child);
                }
                this.contentParticle = this.schema.getGroupParticle(child, ref);
            } else if (ops.matchName(child, this.schema.NS_XS, "all") || ops.matchName(child, this.schema.NS_XS, "choice") || ops.matchName(child, this.schema.NS_XS, "sequence")) {
                this.contentParticle = new ParticleImpl(child, this.schema);
                this.contentParticle.readDefinition();
            }
        }
        this.attributes = new AttributeGroupImpl(child, this.schema);
        this.attributes.readDefinition();
        if (this.contentParticle != null && (term = this.contentParticle.getTerm()).getTermType() == 1 && (group = (ModelGroup)term).getLength() == 0 && (group.getCompositor() != 2 || this.contentParticle.getMinOccurs() == 0)) {
            this.contentParticle = null;
        }
    }

    private void parseComplexExtension(Element complexType, Element complexContent, Element extension) {
        this.derivationMethod = 1;
        this.parseComplexBaseType(extension);
        ComplexType cbase = (ComplexType)this.baseType;
        Element e = ops.firstElementChild(extension);
        if (e != null && ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = ops.nextElementSibling(e);
        }
        this.parseComplexChildren(e);
        if (this.contentParticle == null) {
            this.contentMode = cbase.getContentMode();
            this.contentParticle = (ParticleImpl)cbase.getContentParticle();
        } else {
            this.contentMode = (short)3;
            String attr = complexContent.getAttribute("mixed");
            if (attr.length() > 0) {
                if (attr.equals("true")) {
                    this.contentMode = (short)4;
                }
            } else if ("true".equals(complexType.getAttribute("mixed"))) {
                this.contentMode = (short)4;
            }
            if (cbase.getContentMode() != 1) {
                ModelGroupImpl seq = new ModelGroupImpl(this.schema, 1);
                seq.addItem(cbase.getContentParticle());
                seq.addItem(this.contentParticle);
                this.contentParticle = new ParticleImpl(this.schema, 1, 1, seq);
            }
        }
        AttributeGroup baseAttributes = cbase.getAttributes();
        this.attributes.unionAttributes(baseAttributes);
        if (this.attributes.getWildcard() == null) {
            this.attributes.setWildcard(baseAttributes.getWildcard());
        }
    }

    private void parseComplexBaseType(Element elem) {
        String typeRef = elem.getAttribute("base");
        if (typeRef.length() > 0) {
            this.baseType = this.schema.getType(elem, typeRef);
            if (this.baseType.isComplexType()) {
                return;
            }
            this.error(null, "complexContent base must be complexType", elem);
        } else {
            this.error(null, "base attribute required", elem);
        }
    }

    private void parseSimpleBaseType(Element elem, boolean isExtension) {
        String typeRef = elem.getAttribute("base");
        if (typeRef.length() > 0) {
            this.baseType = this.schema.getType(elem, typeRef);
            if (this.baseType.isComplexType()) {
                this.simpleContentType = ((ComplexType)this.baseType).getSimpleContentType();
                if (this.simpleContentType != null) {
                    return;
                }
            } else if (isExtension) {
                this.simpleContentType = (SimpleType)this.baseType;
                return;
            }
            this.error(null, "simpleContent base must be simple or complex with a simple base", elem);
        } else {
            this.error(null, "base attribute required", elem);
        }
    }
}

