/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema;

import org.apache.tsik.xml.schema.SchemaConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMOperations
implements SchemaConstants {
    static DOMOperations defaultInstance = new DOMOperations();

    public static DOMOperations getInstance() {
        return defaultInstance;
    }

    public Element firstElementChild(Node p) {
        for (Node n = p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Element nextElementSibling(Node s) {
        for (Node n = s.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Node parent(Node n) {
        if (n.getNodeType() == 2) {
            return ((Attr)n).getOwnerElement();
        }
        return n.getParentNode();
    }

    public int depth(Node n) {
        int depth = -1;
        while (n != null) {
            n = this.parent(n);
            ++depth;
        }
        return depth;
    }

    public Document document(Node n) {
        if (n.getNodeType() == 9) {
            return (Document)n;
        }
        return n.getOwnerDocument();
    }

    public String getLocalName(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return name;
        }
        return name.substring(colonPos + 1, name.length());
    }

    public String getLocalName(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name = n.getLocalName();
                if (name != null) {
                    return name;
                }
                return this.getLocalName(n.getNodeName());
            }
        }
        return null;
    }

    public String getPrefix(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return name.substring(0, colonPos);
    }

    public String getPrefix(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name = n.getPrefix();
                if (name != null) {
                    return name;
                }
                return this.getPrefix(n.getNodeName());
            }
        }
        return null;
    }

    public String resolvePrefix(String prefix, Node n) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns";
        }
        while (n != null) {
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                Attr a = prefix == null ? e.getAttributeNode("xmlns") : e.getAttributeNode("xmlns:" + prefix);
                if (a != null) {
                    return a.getValue();
                }
            }
            n = this.parent(n);
        }
        return null;
    }

    public String reverseResolvePrefix(String namespaceURI, Node n) {
        if (namespaceURI == null) {
            namespaceURI = "";
        } else {
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                return "xml";
            }
            if ("http://www.w3.org/2000/xmlns".equals(namespaceURI)) {
                return "xmlns";
            }
        }
        while (n != null) {
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                NamedNodeMap nm = e.getAttributes();
                for (int i = 0; i < nm.getLength(); ++i) {
                    Attr a = (Attr)nm.item(i);
                    if (!a.getNodeValue().equals(namespaceURI)) continue;
                    String aname = a.getNodeName();
                    if (aname.equals("xmlns")) {
                        return null;
                    }
                    if (!aname.startsWith("xmlns:")) continue;
                    return aname.substring(6);
                }
            }
            n = this.parent(n);
        }
        return "[" + namespaceURI + "]";
    }

    public String getNamespaceURI(Node n) {
        short nodeType = n.getNodeType();
        switch (nodeType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        String name = n.getNodeName();
        if (name.equals("xmlns") || name.startsWith("xmlns:")) {
            return "http://www.w3.org/2000/xmlns";
        }
        if (this.getPrefix(n) == null && n.getNodeType() == 2) {
            return null;
        }
        String prefix = this.getPrefix(n);
        if (nodeType == 2 && prefix == null) {
            return null;
        }
        return this.resolvePrefix(this.getPrefix(n), n);
    }

    public boolean matchName(Node n, String namespaceURI, String localName) {
        String nns = this.getNamespaceURI(n);
        String nln = this.getLocalName(n);
        return (nns == null ? namespaceURI == null : nns.equals(namespaceURI)) && (nln == null ? localName == null : nln.equals(localName));
    }

    public String getNodePath(Node n) {
        switch (n.getNodeType()) {
            case 9: 
            case 11: {
                return "";
            }
            case 2: {
                return this.getNodePath(((Attr)n).getOwnerElement()) + "/@" + n.getNodeName();
            }
            case 1: {
                return this.getNodePath(n.getParentNode()) + "/" + n.getNodeName();
            }
            case 3: 
            case 4: {
                return this.getNodePath(n.getParentNode()) + "/text()";
            }
        }
        throw new IllegalArgumentException();
    }

    private static void collectText(Node node, StringBuffer sb) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                sb.append(node.getNodeValue());
                break;
            }
            default: {
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    DOMOperations.collectText(node, sb);
                }
            }
        }
    }

    public String stringValueOfNode(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                StringBuffer sb = new StringBuffer();
                DOMOperations.collectText(node, sb);
                return sb.toString();
            }
        }
        return node.getNodeValue();
    }

    public String replaceWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        block3: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    sb.append(' ');
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public String collapseWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        boolean gotSpace = true;
        block3: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (gotSpace) continue block3;
                    sb.append(' ');
                    gotSpace = true;
                    continue block3;
                }
                default: {
                    gotSpace = false;
                    sb.append(ch);
                }
            }
        }
        if (gotSpace && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

