/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.actions;

import java.security.cert.X509Certificate;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.wss.Id;
import org.apache.tsik.wss.elements.BinarySecurityToken;
import org.apache.tsik.xpath.XPath;

public class CreateBinarySecurityToken
extends Action {
    private X509Certificate cert;
    private XPath outputXpath;

    private boolean checkPreconditions() {
        this.cert = this.getX509Certificate("cert");
        this.outputXpath = this.getXPath("output");
        if (this.cert == null || this.outputXpath == null) {
            return false;
        }
        return this.moveOutputToXPath(this.outputXpath);
    }

    public void execute() {
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precond check failed"));
            return;
        }
        BinarySecurityToken bst = new BinarySecurityToken(this.cert);
        bst.toXml(this.output);
        this.output.moveToChild(1);
        String id = Id.generateId();
        Id.insertInto(this.output, id);
        this.map.put("output", this.output.createXPath());
        this.map.put("id", id);
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

