/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.verifier;

import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.tsik.datatypes.HashedByteArray;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class CachingTrustVerifier
implements TrustVerifier {
    private TrustVerifier verifier;
    private long interval;
    private boolean cacheFailures;
    private Entry noDataEntry;
    private Map certMap;
    private Map keyNameMap;
    private Map keyValueMap;

    public CachingTrustVerifier(TrustVerifier verifier, long interval) {
        this.verifier = verifier;
        this.interval = interval;
        this.noDataEntry = new Entry();
        this.certMap = new HashMap();
        this.keyNameMap = new HashMap();
        this.keyValueMap = new HashMap();
    }

    public void verifyTrust() throws TrustVerificationException {
        Entry entry = this.noDataEntry;
        if (this.shouldVerifyNow(entry)) {
            try {
                this.verifier.verifyTrust();
                entry.exception = null;
            }
            catch (TrustVerificationException e) {
                entry.exception = e;
            }
        }
        if (entry.exception != null) {
            throw entry.exception;
        }
    }

    public void verifyTrust(PublicKey key) throws TrustVerificationException {
        Entry entry = this.getEntry(this.keyValueMap, new HashedByteArray(key.getEncoded()));
        if (this.shouldVerifyNow(entry)) {
            try {
                this.verifier.verifyTrust(key);
                entry.exception = null;
            }
            catch (TrustVerificationException e) {
                entry.exception = e;
            }
        }
        if (entry.exception != null) {
            throw entry.exception;
        }
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        Entry entry = keyName != null ? this.getEntry(this.keyNameMap, keyName) : this.getEntry(this.keyValueMap, new HashedByteArray(key.getEncoded()));
        if (this.shouldVerifyNow(entry)) {
            try {
                this.verifier.verifyTrust(key, keyName);
                entry.exception = null;
            }
            catch (TrustVerificationException e) {
                entry.exception = e;
            }
        }
        if (entry.exception != null) {
            throw entry.exception;
        }
    }

    public void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        StringBuffer certKey = new StringBuffer(200 * chain.length);
        for (int i = 0; i < chain.length; ++i) {
            Principal issuerDN = chain[i].getIssuerDN();
            BigInteger serialNumber = chain[i].getSerialNumber();
            certKey.append(issuerDN.getName());
            certKey.append(serialNumber.toString());
        }
        Entry entry = this.getEntry(this.certMap, certKey.toString());
        if (this.shouldVerifyNow(entry)) {
            try {
                this.verifier.verifyTrust(chain);
                entry.exception = null;
            }
            catch (TrustVerificationException e) {
                entry.exception = e;
            }
        }
        if (entry.exception != null) {
            throw entry.exception;
        }
    }

    private boolean shouldVerifyNow(Entry entry) {
        long newTime = System.currentTimeMillis();
        if (entry.exception == null || this.cacheFailures) {
            if (newTime - entry.lastVerifyTime > this.interval) {
                entry.lastVerifyTime = newTime;
                return true;
            }
            return false;
        }
        entry.lastVerifyTime = newTime;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(Map map, Object key) {
        Map map2 = map;
        synchronized (map2) {
            Entry entry = (Entry)map.get(key);
            if (entry == null) {
                entry = new Entry();
                map.put(key, entry);
            }
            return entry;
        }
    }

    private static class Entry {
        long lastVerifyTime;
        TrustVerificationException exception;

        private Entry() {
        }
    }
}

