/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.uuid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.tsik.uuid.NodeIDGetter;
import org.apache.tsik.uuid.TimestampUUIDGenerator;
import org.apache.tsik.uuid.UUIDGenerator;
import org.apache.tsik.uuid.UUIDRandomness;

public final class UUID
implements Serializable {
    public static final int VARIANT_NCS = 0;
    public static final int VARIANT_NCS_MASK = 128;
    public static final int VARIANT_DCE = 128;
    public static final int VARIANT_DCE_MASK = 192;
    public static final int VARIANT_MICROSOFT = 192;
    public static final int VARIANT_MICROSOFT_MASK = 224;
    public static final int VARIANT_RESERVED = 224;
    public static final int VARIANT_RESERVED_MASK = 224;
    public static final int VERSION_TIMESTAMP = 4096;
    public static final int VERSION_UID = 8192;
    public static final int VERSION_NAME = 12288;
    public static final int VERSION_RANDOM = 16384;
    public static final int VERSION_MASK = 61440;
    private transient int time_low;
    private transient short time_mid;
    private transient short time_hi_and_version;
    private transient byte clock_seq_hi_and_reserved;
    private transient byte clock_seq_low;
    private transient byte[] node;
    private transient int hash_code;
    private transient String string_rep;
    private transient byte[] binary_rep;
    private static UUIDGenerator default_generator;
    public static final UUID nil;

    public UUID(int time_low, short time_mid, short time_hi_and_version, byte clock_seq_low, byte clock_seq_hi_and_reserved, byte[] node) throws NullPointerException, IllegalArgumentException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node.length != 6) {
            throw new IllegalArgumentException();
        }
        this.time_low = time_low;
        this.time_mid = time_mid;
        this.time_hi_and_version = time_hi_and_version;
        this.clock_seq_low = clock_seq_low;
        this.clock_seq_hi_and_reserved = clock_seq_hi_and_reserved;
        this.node = new byte[6];
        System.arraycopy(node, 0, this.node, 0, 6);
    }

    public UUID(String s) throws NullPointerException, IllegalArgumentException, NumberFormatException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.length() != 36) {
            throw new IllegalArgumentException();
        }
        this.time_low = UUID.parseHex(s.substring(0, 8));
        if (s.charAt(8) != '-') {
            throw new IllegalArgumentException();
        }
        this.time_mid = (short)UUID.parseHex(s.substring(9, 13));
        if (s.charAt(13) != '-') {
            throw new IllegalArgumentException();
        }
        this.time_hi_and_version = (short)UUID.parseHex(s.substring(14, 18));
        if (s.charAt(18) != '-') {
            throw new IllegalArgumentException();
        }
        this.clock_seq_hi_and_reserved = (byte)UUID.parseHex(s.substring(19, 21));
        this.clock_seq_low = (byte)UUID.parseHex(s.substring(21, 23));
        if (s.charAt(23) != '-') {
            throw new IllegalArgumentException();
        }
        this.node = new byte[6];
        for (int i = 0; i < 6; ++i) {
            this.node[i] = (byte)UUID.parseHex(s.substring(2 * i + 24, 2 * i + 26));
        }
    }

    public UUID(DataInput in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        this.readData(in);
    }

    public UUID(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.length != 16) {
            throw new IllegalArgumentException();
        }
        try {
            this.readData(new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException();
        }
    }

    private void readData(DataInput in) throws IOException {
        this.time_low = in.readInt();
        this.time_mid = in.readShort();
        this.time_hi_and_version = in.readShort();
        this.clock_seq_hi_and_reserved = in.readByte();
        this.clock_seq_low = in.readByte();
        this.node = new byte[6];
        in.readFully(this.node);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readData(in);
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.time_low);
        out.writeShort(this.time_mid);
        out.writeShort(this.time_hi_and_version);
        out.writeByte(this.clock_seq_hi_and_reserved);
        out.writeByte(this.clock_seq_low);
        out.write(this.node);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeData(out);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UUID)) {
            return false;
        }
        UUID other = (UUID)obj;
        if (this == other) {
            return true;
        }
        if (this.hash_code != 0 && other.hash_code != 0 && this.hash_code != other.hash_code) {
            return false;
        }
        return this.time_low == other.time_low && this.time_mid == other.time_mid && this.time_hi_and_version == other.time_hi_and_version && this.clock_seq_low == other.clock_seq_low && this.clock_seq_hi_and_reserved == other.clock_seq_hi_and_reserved && Arrays.equals(this.node, other.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.hash_code == 0) {
            UUID uUID = this;
            synchronized (uUID) {
                if (this.hash_code == 0) {
                    this.hash_code = this.toString().hashCode();
                    if (this.hash_code == 0) {
                        this.hash_code = -1;
                    }
                }
            }
        }
        return this.hash_code;
    }

    private static void appendHex(StringBuffer sb, long num, int digits) {
        if (digits > 0 && digits < 16) {
            num &= (1L << digits * 4) - 1L;
        }
        String str = Long.toHexString(num);
        for (int len = str.length(); len < digits; ++len) {
            sb.append('0');
        }
        sb.append(str);
    }

    private static int parseHex(String s) throws NumberFormatException {
        if (s.charAt(0) == '-') {
            throw new NumberFormatException();
        }
        return Integer.parseInt(s, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.string_rep == null) {
            UUID uUID = this;
            synchronized (uUID) {
                if (this.string_rep == null) {
                    StringBuffer sb = new StringBuffer();
                    UUID.appendHex(sb, this.time_low, 8);
                    sb.append('-');
                    UUID.appendHex(sb, this.time_mid, 4);
                    sb.append('-');
                    UUID.appendHex(sb, this.time_hi_and_version, 4);
                    sb.append('-');
                    UUID.appendHex(sb, this.clock_seq_hi_and_reserved, 2);
                    UUID.appendHex(sb, this.clock_seq_low, 2);
                    sb.append('-');
                    for (int i = 0; i < 6; ++i) {
                        UUID.appendHex(sb, this.node[i], 2);
                    }
                    this.string_rep = sb.toString();
                }
            }
        }
        return this.string_rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        if (this.binary_rep == null) {
            UUID uUID = this;
            synchronized (uUID) {
                if (this.binary_rep == null) {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
                        this.writeData(new DataOutputStream(baos));
                        this.binary_rep = baos.toByteArray();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException();
                    }
                }
            }
        }
        return (byte[])this.binary_rep.clone();
    }

    public static UUID generate() {
        if (default_generator == null) {
            default_generator = new TimestampUUIDGenerator(UUIDRandomness.randomClockSequence(), NodeIDGetter.getNodeID());
        }
        return default_generator.nextUUID();
    }

    public static UUID fromName(UUID namespace, String name) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            namespace.writeData(dos);
            dos.flush();
            md5.update(baos.toByteArray());
            baos.reset();
            dos.writeUTF(name);
            dos.flush();
            byte[] data = baos.toByteArray();
            md5.update(data, 2, data.length - 2);
            data = md5.digest();
            UUID uuid = new UUID(data);
            uuid.clock_seq_hi_and_reserved = (byte)(uuid.clock_seq_hi_and_reserved & 0xFFFFFF3F | 0x80);
            uuid.time_hi_and_version = (short)(uuid.time_hi_and_version & 0xFFFF0FFF | 0x3000);
            return uuid;
        }
        catch (Exception ex) {
            throw new RuntimeException();
        }
    }

    static {
        nil = new UUID(0, 0, 0, 0, 0, new byte[]{0, 0, 0, 0, 0, 0});
    }
}

