/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.c14n;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tsik.c14n.AttributeComparator;
import org.apache.tsik.c14n.Canonicalizer;
import org.apache.tsik.c14n.CanonicalizerFactory;
import org.apache.tsik.c14n.SAXHandler;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.resource.DOMOperations;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class AbstractCanonicalizer
implements Canonicalizer {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$c14n$AbstractCanonicalizer == null ? (class$org$apache$tsik$c14n$AbstractCanonicalizer = AbstractCanonicalizer.class$("org.apache.tsik.c14n.AbstractCanonicalizer")) : class$org$apache$tsik$c14n$AbstractCanonicalizer);
    static final DOMOperations ops = DOMOperations.getInstance();
    private static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    private Set removeSet;
    private boolean useComments = false;
    private PrintWriter out = null;
    private ByteArrayOutputStream baos = null;
    static /* synthetic */ Class class$org$apache$tsik$c14n$AbstractCanonicalizer;

    AbstractCanonicalizer(boolean useComments) {
        this.useComments = useComments;
        this.baos = new ByteArrayOutputStream();
        try {
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)this.baos, "UTF8"));
        }
        catch (IOException unexpected) {
            throw new IllegalArgumentException(unexpected.toString());
        }
    }

    public byte[] canonicalize(Node node, Map parentNamespaces) {
        this.removeSet = new HashSet();
        Document doc = node.getOwnerDocument();
        if (doc == null) {
            doc = (Document)node;
        }
        this.addNamespacesFromParents(node);
        this.process(node, node);
        this.out.flush();
        Iterator i = this.removeSet.iterator();
        while (i.hasNext()) {
            Node foo = (Node)i.next();
            log.debug("Removing attribute xmlns in node " + foo);
            ((Element)foo).removeAttribute("xmlns");
        }
        byte[] b = this.baos.toByteArray();
        log.debug("Canonicalizer returns length: " + b.length);
        return b;
    }

    public SAXHandler getSAXHandler(Map parentNamespaces) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public byte[] getSAXResult() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    abstract void handleAncestralNamespaces(Node var1, Map var2);

    abstract boolean shouldAncestralAttributeBeAdded(Attr var1, Node var2);

    abstract void beforeElement(Node var1);

    abstract void afterElement(Node var1);

    Map gatherNamespacesFromParents(Node node) {
        Vector<Node> nodes = new Vector<Node>();
        Node parent = node;
        nodes.add(node);
        while ((parent = parent.getParentNode()) != null) {
            if (parent.getNodeType() == 9) continue;
            nodes.add(parent);
        }
        nodes.trimToSize();
        Collections.reverse(nodes);
        HashMap<String, Attr> parentsNamespaces = new HashMap<String, Attr>();
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = (Node)nodes.get(i);
            log.debug("Collect namespaces from node " + n);
            NamedNodeMap map = n.getAttributes();
            if (map == null) continue;
            int mapLen = map.getLength();
            for (int j = 0; j < mapLen; ++j) {
                Attr attr = (Attr)map.item(j);
                if (!AttributeComparator.isNamespaceAttr(attr)) continue;
                log.debug("Collect namespace: " + attr + " from " + n.getNodeName());
                parentsNamespaces.put(ops.getLocalName(attr), attr);
            }
        }
        return parentsNamespaces;
    }

    protected void addNamespacesFromParents(Node node) {
        Map parentsNamespaces = this.gatherNamespacesFromParents(node);
        this.handleAncestralNamespaces(node, parentsNamespaces);
        Iterator iter = parentsNamespaces.values().iterator();
        while (iter.hasNext()) {
            Attr attr = (Attr)iter.next();
            String name = attr.getName();
            String value = attr.getValue();
            if (!this.shouldAncestralAttributeBeAdded(attr, node)) {
                log.debug("Not adding attribute " + name + " to node" + node);
                continue;
            }
            log.debug("Adding attribute " + name + " to node" + node);
            Element elem = (Element)node;
            elem.removeAttribute(name);
            elem.removeAttributeNS(NS_XMLNS, name);
            elem.setAttributeNS(NS_XMLNS, name, value);
        }
    }

    private void process(Node n, Node topNode) {
        this.nodeStart(n, topNode);
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.process(child, topNode);
        }
        this.nodeEnd(n);
    }

    private void nodeStart(Node node, Node topNode) {
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                throw new IllegalStateException("Illegal node: " + node.getNodeName());
            }
            case 5: 
            case 9: {
                break;
            }
            case 8: {
                if (!this.useComments) break;
                this.out.print("<!--");
                this.out.print(node.getNodeValue());
                break;
            }
            case 1: {
                this.beforeElement(node);
                this.out.print('<');
                this.out.print(node.getNodeName());
                if (node == topNode) {
                    this.removeExtraTopNodeNamespaces(topNode);
                } else {
                    this.removeExtraNamespaces(node, topNode);
                }
                NamedNodeMap map = node.getAttributes();
                Attr[] attrs = AbstractCanonicalizer.sortAttributes(map);
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(AbstractCanonicalizer.escape(true, attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print(">");
                break;
            }
            case 3: 
            case 4: {
                this.out.print(AbstractCanonicalizer.escape(false, node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data == null || data.length() <= 0) break;
                this.out.print(' ');
                this.out.print(data);
                break;
            }
        }
    }

    protected void removeExtraTopNodeNamespaces(Node topNode) {
        Attr attr;
        Element elem = (Element)topNode;
        if (elem == elem.getOwnerDocument().getDocumentElement() && (attr = elem.getAttributeNode("xmlns")) != null && attr.getValue().length() == 0) {
            elem.removeAttributeNode(attr);
        }
    }

    protected Node removeExtraNamespaces(Node node, Node topNode) {
        Attr attr;
        Vector<Node> nodes = new Vector<Node>();
        Node parent = node;
        while (parent != topNode && (parent = parent.getParentNode()) != null) {
            if (parent.getNodeType() == 9) continue;
            nodes.add(parent);
        }
        nodes.trimToSize();
        Vector<Attr> removeVector = new Vector<Attr>();
        NamedNodeMap map = node.getAttributes();
        int mapLen = map.getLength();
        block1: for (int i = 0; i < mapLen; ++i) {
            attr = (Attr)map.item(i);
            String name = attr.getNodeName();
            if (!name.startsWith("xmlns")) continue;
            for (int j = 0; j < nodes.size(); ++j) {
                NamedNodeMap attrMap;
                Node n = (Node)nodes.get(j);
                Attr foo = ((Element)n).getAttributeNode("xmlns");
                if (foo == null) {
                    log.debug("No default namespace found -- adding to element " + n);
                    ((Element)n).setAttribute("xmlns", "");
                    this.removeSet.add(n);
                }
                if ((attrMap = n.getAttributes()) == null) {
                    log.debug("No attributes found in element " + n + " -- adding empty default namespace");
                    ((Element)n).setAttribute("xmlns", "");
                    this.removeSet.add(n);
                    attrMap = n.getAttributes();
                }
                int lenAttrMap = attrMap.getLength();
                for (int k = 0; k < lenAttrMap; ++k) {
                    String nodeValue;
                    Attr nodeAttr = (Attr)attrMap.item(k);
                    if (!name.equals(nodeAttr.getNodeName())) continue;
                    String ourValue = attr.getValue();
                    if (!ourValue.equals(nodeValue = nodeAttr.getValue())) continue block1;
                    removeVector.add(attr);
                    continue block1;
                }
            }
        }
        Enumeration e = removeVector.elements();
        while (e.hasMoreElements()) {
            attr = (Attr)e.nextElement();
            map.removeNamedItem(attr.getNodeName());
        }
        return node;
    }

    private void nodeEnd(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 8: {
                if (!this.useComments) break;
                this.out.print("-->");
                break;
            }
            case 1: {
                this.out.print("</");
                this.out.print(node.getNodeName());
                this.out.print('>');
                this.afterElement(node);
                break;
            }
            case 7: {
                this.out.print("?>");
                break;
            }
        }
    }

    protected static final Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        Arrays.sort(array, new AttributeComparator());
        return array;
    }

    static String escape(boolean isAttr, String s) {
        String ss;
        if (s == null) {
            return s;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        StringBuffer buf = null;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            buf = new StringBuffer();
        }
        for (int i = 0; i < len; ++i) {
            String esc;
            char ch = s.charAt(i);
            String string = esc = isAttr ? AbstractCanonicalizer.escapeAttrChar(ch) : AbstractCanonicalizer.escapeTextChar(ch);
            if (esc != null) {
                if (buf == null) {
                    buf = i > 0 ? new StringBuffer(s.substring(0, i)) : new StringBuffer(len * 2);
                }
                buf.append(esc);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        String string = ss = buf != null ? buf.toString() : s;
        if (log.isDebugEnabled()) {
            log.debug("C14n escape(): " + ss);
            log.debug("C14n escape() length: " + ss.length());
        }
        return ss;
    }

    static String escape(boolean isAttr, char[] chars, int off, int len) {
        String retVal;
        if (len == 0) {
            return null;
        }
        StringBuffer buf = null;
        for (int i = off; i < len; ++i) {
            String esc;
            char ch = chars[i];
            String string = esc = isAttr ? AbstractCanonicalizer.escapeAttrChar(ch) : AbstractCanonicalizer.escapeTextChar(ch);
            if (esc != null) {
                if (buf == null) {
                    buf = i > off ? new StringBuffer(new String(chars, i, off - i)) : new StringBuffer(len * 2);
                }
                buf.append(esc);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        String string = retVal = buf != null ? buf.toString() : null;
        if (log.isDebugEnabled()) {
            String ss = retVal != null ? retVal : new String(chars, off, len);
            log.debug("C14n escape(): " + ss);
            log.debug("C14n escape() length: " + ss.length());
        }
        return retVal;
    }

    private static String escapeTextChar(char ch) {
        switch (ch) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\r': {
                return "&#xD;";
            }
        }
        return null;
    }

    private static String escapeAttrChar(char ch) {
        switch (ch) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\r': {
                return "&#xD;";
            }
            case '\n': {
                return "&#xA;";
            }
            case '\t': {
                return "&#x9;";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

