/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;

public class ExprFactory {
    static BooleanExpr createExpr(XPath xPath, SimpleStreamTokenizer simpleStreamTokenizer) throws XPathException, IOException {
        switch (simpleStreamTokenizer.ttype) {
            default: {
                throw new XPathException(xPath, "at beginning of expression", simpleStreamTokenizer, "@, number, or text()");
            }
            case -2: {
                int n = simpleStreamTokenizer.nval;
                simpleStreamTokenizer.nextToken();
                return new PositionEqualsExpr(n);
            }
            case 64: {
                if (simpleStreamTokenizer.nextToken() != -3) {
                    throw new XPathException(xPath, "after @", simpleStreamTokenizer, "name");
                }
                String string = simpleStreamTokenizer.sval;
                switch (simpleStreamTokenizer.nextToken()) {
                    case 61: {
                        simpleStreamTokenizer.nextToken();
                        if (simpleStreamTokenizer.ttype != 34 && simpleStreamTokenizer.ttype != 39) {
                            throw new XPathException(xPath, "right hand side of equals", simpleStreamTokenizer, "quoted string");
                        }
                        String string2 = simpleStreamTokenizer.sval;
                        simpleStreamTokenizer.nextToken();
                        return new AttrEqualsExpr(string, string2);
                    }
                    case 60: {
                        int n;
                        simpleStreamTokenizer.nextToken();
                        if (simpleStreamTokenizer.ttype == 34 || simpleStreamTokenizer.ttype == 39) {
                            n = Integer.parseInt(simpleStreamTokenizer.sval);
                        } else if (simpleStreamTokenizer.ttype == -2) {
                            n = simpleStreamTokenizer.nval;
                        } else {
                            throw new XPathException(xPath, "right hand side of less-than", simpleStreamTokenizer, "quoted string or number");
                        }
                        simpleStreamTokenizer.nextToken();
                        return new AttrLessExpr(string, n);
                    }
                    case 62: {
                        int n;
                        simpleStreamTokenizer.nextToken();
                        if (simpleStreamTokenizer.ttype == 34 || simpleStreamTokenizer.ttype == 39) {
                            n = Integer.parseInt(simpleStreamTokenizer.sval);
                        } else if (simpleStreamTokenizer.ttype == -2) {
                            n = simpleStreamTokenizer.nval;
                        } else {
                            throw new XPathException(xPath, "right hand side of greater-than", simpleStreamTokenizer, "quoted string or number");
                        }
                        simpleStreamTokenizer.nextToken();
                        return new AttrGreaterExpr(string, n);
                    }
                    case 33: {
                        simpleStreamTokenizer.nextToken();
                        if (simpleStreamTokenizer.ttype != 61) {
                            throw new XPathException(xPath, "after !", simpleStreamTokenizer, "=");
                        }
                        simpleStreamTokenizer.nextToken();
                        if (simpleStreamTokenizer.ttype != 34 && simpleStreamTokenizer.ttype != 39) {
                            throw new XPathException(xPath, "right hand side of !=", simpleStreamTokenizer, "quoted string");
                        }
                        String string3 = simpleStreamTokenizer.sval;
                        simpleStreamTokenizer.nextToken();
                        return new AttrNotEqualsExpr(string, string3);
                    }
                }
                return new AttrExistsExpr(string);
            }
            case -3: 
        }
        if (!simpleStreamTokenizer.sval.equals("text")) {
            throw new XPathException(xPath, "at beginning of expression", simpleStreamTokenizer, "text()");
        }
        if (simpleStreamTokenizer.nextToken() != 40) {
            throw new XPathException(xPath, "after text", simpleStreamTokenizer, "(");
        }
        if (simpleStreamTokenizer.nextToken() != 41) {
            throw new XPathException(xPath, "after text(", simpleStreamTokenizer, ")");
        }
        switch (simpleStreamTokenizer.nextToken()) {
            case 61: {
                simpleStreamTokenizer.nextToken();
                if (simpleStreamTokenizer.ttype != 34 && simpleStreamTokenizer.ttype != 39) {
                    throw new XPathException(xPath, "right hand side of equals", simpleStreamTokenizer, "quoted string");
                }
                String string = simpleStreamTokenizer.sval;
                simpleStreamTokenizer.nextToken();
                return new TextEqualsExpr(string);
            }
            case 33: {
                simpleStreamTokenizer.nextToken();
                if (simpleStreamTokenizer.ttype != 61) {
                    throw new XPathException(xPath, "after !", simpleStreamTokenizer, "=");
                }
                simpleStreamTokenizer.nextToken();
                if (simpleStreamTokenizer.ttype != 34 && simpleStreamTokenizer.ttype != 39) {
                    throw new XPathException(xPath, "right hand side of !=", simpleStreamTokenizer, "quoted string");
                }
                String string = simpleStreamTokenizer.sval;
                simpleStreamTokenizer.nextToken();
                return new TextNotEqualsExpr(string);
            }
        }
        return TextExistsExpr.INSTANCE;
    }
}

