/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.session;

import java.io.Serializable;
import java.util.Date;
import net.jradius.exception.RadiusException;
import net.jradius.log.JRadiusLogEntry;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusRequest;

public interface JRadiusSession
extends Serializable {
    public static final long serialVersionUID = 0L;
    public static final int RADIUS_ERROR = -1;
    public static final int UNKNOWN_STATE = 0;
    public static final int AUTH_PENDING = 1;
    public static final int AUTH_ACCEPTED = 2;
    public static final int AUTH_REJECTED = 4;
    public static final int ACCT_STARTED = 8;
    public static final int ACCT_STOPPED = 16;
    public static final int SESSION_STARTED = 11;
    public static final int SESSION_STOPPED = 27;
    public static final int ACCT_ONLY_STARTED = 8;
    public static final int ACCT_ONLY_STOPPED = 24;
    public static final String SESSION_ATTRIBUTE_LOCATION_ID = "locationID";
    public static final String SESSION_ATTRIBUTE_LOCATION_TYPE = "locationType";
    public static final String SESSION_ATTRIBUTE_LOCATION_NAME = "locationName";
    public static final String SESSION_ATTRIBUTE_LOCATION_CITY = "locationCity";
    public static final String SESSION_ATTRIBUTE_LOCATION_STATE_PROVINCE = "locationStateProvince";
    public static final String SESSION_ATTRIBUTE_LOCATION_COUNTRY_CODE = "locationCountryCode";

    public JRadiusLogEntry getLogEntry(JRadiusEvent var1, String var2);

    public JRadiusLogEntry getLogEntry(JRadiusRequest var1) throws RadiusException;

    public void addLogMessage(JRadiusRequest var1, String var2) throws RadiusException;

    public void commitLogEntry(JRadiusLogEntry var1, int var2);

    public void commitLogEntries(int var1);

    public void lock();

    public void unlock();

    public void initSession(JRadiusRequest var1) throws RadiusException;

    public void setAttribute(String var1, Serializable var2);

    public Serializable getAttribute(String var1);

    public void onPostProcessing(JRadiusRequest var1) throws RadiusException;

    public void onAuthorization(JRadiusRequest var1) throws RadiusException;

    public boolean onPreProcessing(JRadiusRequest var1) throws RadiusException;

    public void onPostAuthentication(JRadiusRequest var1) throws RadiusException;

    public void onAccounting(JRadiusRequest var1) throws RadiusException;

    public boolean onNoAccountingStatusType(JRadiusRequest var1) throws RadiusException;

    public void ensureSessionState(JRadiusRequest var1, int var2) throws RadiusException;

    public boolean isAccountingReversed();

    public String getUsername();

    public void setUsername(String var1);

    public String getRealm();

    public void setRealm(String var1);

    public String getPassword();

    public void setPassword(String var1);

    public String getSessionKey();

    public void setSessionKey(String var1);

    public String getSessionId();

    public void setSessionId(String var1);

    public Long getServiceType();

    public void setServiceType(Long var1);

    public Long getIdleTimeout();

    public void setIdleTimeout(Long var1);

    public Long getInterimInterval();

    public void setInterimInterval(Long var1);

    public Long getSessionTimeout();

    public void setSessionTimeout(Long var1);

    public Long getSessionTime();

    public void setSessionTime(Long var1);

    public Date getStartTime();

    public void setStartTime(Date var1);

    public Date getLastInterimTime();

    public void setLastInterimTime(Date var1);

    public Date getStopTime();

    public void setStopTime(Date var1);

    public Long getGigaWordsIn();

    public void setGigaWordsIn(Long var1);

    public Long getGigaWordsOut();

    public void setGigaWordsOut(Long var1);

    public Long getOctetsIn();

    public void setOctetsIn(Long var1);

    public Long getOctetsOut();

    public void setOctetsOut(Long var1);

    public Long getTotalOctetsIn();

    public Long getTotalOctetsOut();

    public Long getPacketsIn();

    public void setPacketsIn(Long var1);

    public Long getPacketsOut();

    public void setPacketsOut(Long var1);

    public Long getTerminateCause();

    public void setTerminateCause(Long var1);

    public byte[][] getRadiusClass();

    public void setRadiusClass(byte[][] var1);

    public int getSessionState();

    public void setSessionState(int var1);

    public String getProxyToRealm();

    public void setProxyToRealm(String var1);

    public boolean isSecured();

    public void setSecured(boolean var1);

    public String getCalledStationId();

    public void setCalledStationId(String var1);

    public String getCallingStationId();

    public void setCallingStationId(String var1);

    public String getConnectInfo();

    public void setConnectInfo(String var1);

    public String getClientIPAddress();

    public void setClientIPAddress(String var1);

    public String getNasIdentifier();

    public void setNasIdentifier(String var1);

    public String getNasIPAddress();

    public void setNasIPAddress(String var1);

    public String getFramedIPAddress();

    public void setFramedIPAddress(String var1);

    public long getTimeStamp();

    public void setTimeStamp(long var1);

    public Long getMaxBandwidthDown();

    public void setMaxBandwidthDown(Long var1);

    public Long getMaxBandwidthUp();

    public void setMaxBandwidthUp(Long var1);

    public Long getMinBandwidthDown();

    public void setMinBandwidthDown(Long var1);

    public Long getMinBandwidthUp();

    public void setMinBandwidthUp(Long var1);

    public Long getMaxOctetsDown();

    public void setMaxOctetsDown(Long var1);

    public Long getMaxOctetsUp();

    public void setMaxOctetsUp(Long var1);

    public Long getMaxOctetsTotal();

    public void setMaxOctetsTotal(Long var1);

    public String getNasType();

    public void setNasType(String var1);

    public String getRedirectURL();

    public void setRedirectURL(String var1);

    public String getJRadiusKey();

    public void setJRadiusKey(String var1);

    public JRadiusRequest getLastRadiusRequest();

    public void setLastRadiusRequest(JRadiusRequest var1);

    public boolean isLogging();
}

