/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusThread;
import net.jradius.server.event.ServerEvent;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import org.apache.commons.chain.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher
extends JRadiusThread {
    private BlockingQueue<JRadiusEvent> eventQueue = new LinkedBlockingQueue<JRadiusEvent>();
    private List<JRCommand> eventHandlers = new LinkedList<JRCommand>();
    private volatile boolean active = false;

    public void post(JRadiusEvent event) {
        while (this.getActive()) {
            try {
                this.eventQueue.put(event);
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void run() {
        this.active = true;
        while (this.getActive()) {
            try {
                Thread.yield();
                this.dispatchEvent();
            }
            catch (Throwable e) {
                RadiusLog.error("Error during event dispatch", e);
            }
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent() {
        JRadiusEvent event = null;
        while (this.getActive()) {
            try {
                event = this.eventQueue.take();
                break;
            }
            catch (InterruptedException e) {
            }
        }
        if (event != null) {
            JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager(event.getSender());
            JRadiusSession session = null;
            if (event instanceof ServerEvent) {
                session = ((ServerEvent)event).getRequest().getSession();
            }
            if (session != null) {
                sessionManager.lock(session);
            }
            try {
                for (JRCommand command : this.eventHandlers) {
                    try {
                        if (!command.doesHandle(event) || !command.execute((Context)event)) continue;
                        break;
                    }
                    catch (Throwable e) {
                        RadiusLog.error("Event handler " + command.getName() + " threw an exception", e);
                    }
                }
            }
            finally {
                if (session != null) {
                    sessionManager.unlock(session, false);
                }
            }
        }
    }

    public List<JRCommand> getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(List<JRCommand> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }
}

