/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute.value;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import net.jradius.packet.attribute.value.AttributeValue;
import net.jradius.packet.attribute.value.IntegerValue;

public class DateValue
extends IntegerValue {
    private static final long serialVersionUID = 0L;
    private Date dateValue;

    public DateValue() {
    }

    public DateValue(Date d) {
        this.dateValue = d;
    }

    public void copy(AttributeValue value) {
        DateValue dValue = (DateValue)value;
        this.integerValue = dValue.integerValue;
        this.length = dValue.length;
        this.dateValue = dValue.dateValue;
    }

    public void getBytes(OutputStream out) throws IOException {
        this.integerValue = new Long(this.dateValue.getTime() / 1000L);
        super.getBytes(out);
    }

    public void setValue(byte[] b) {
        super.setValue(b);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    public void setValue(int i) {
        super.setValue(i);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    public void setValue(long l) {
        super.setValue(l);
        this.dateValue = new Date(this.integerValue * 1000L);
    }

    public String toString() {
        if (this.dateValue != null) {
            return this.dateValue.toString();
        }
        return "[Bad Date Value]";
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<time>");
        if (this.dateValue != null) {
            sb.append(this.dateValue.getTime());
        }
        sb.append("</time>");
        return sb.toString();
    }

    public void setDate(Date newDate) {
        this.dateValue = newDate;
        this.integerValue = new Long(this.dateValue.getTime() / 1000L);
    }

    public Serializable getValueObject() {
        return this.dateValue;
    }

    public void setValueObject(Serializable o) {
        if (o instanceof Date) {
            this.setDate((Date)o);
        } else if (o instanceof Number) {
            this.setDate(new Date(((Number)o).longValue() * 1000L));
        } else {
            this.setDate(new Date(Long.parseLong(o.toString()) * 1000L));
        }
    }
}

