/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.InputStream;
import java.nio.ByteBuffer;
import net.jradius.exception.RadiusException;
import net.jradius.freeradius.FreeRadiusFormat;
import net.jradius.freeradius.FreeRadiusRequest;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.ListenerRequest;
import net.jradius.server.TCPListener;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;

public class FreeRadiusListener
extends TCPListener {
    private static final FreeRadiusFormat format = new FreeRadiusFormat();
    private ObjectPool requestObjectPool = new SoftReferenceObjectPool(new PoolableObjectFactory(){

        public boolean validateObject(Object arg0) {
            return true;
        }

        public void passivateObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            return new FreeRadiusRequest();
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public void activateObject(Object arg0) throws Exception {
        }
    });

    public JRadiusEvent parseRequest(ListenerRequest listenerRequest, ByteBuffer notUsed, InputStream in) throws Exception {
        int result;
        FreeRadiusRequest request = (FreeRadiusRequest)((Object)this.requestObjectPool.borrowObject());
        request.setBorrowedFromPool(this.requestObjectPool);
        int totalLength = (int)(RadiusFormat.readUnsignedInt(in) - 4L);
        ByteBuffer buffer = request.buffer_in;
        if (totalLength < 0 || totalLength > buffer.capacity()) {
            return null;
        }
        buffer.clear();
        byte[] payload = buffer.array();
        for (int readOffset = 0; readOffset < totalLength; readOffset += result) {
            result = in.read(payload, readOffset, totalLength - readOffset);
            if (result >= 0) continue;
            return null;
        }
        buffer.limit(totalLength);
        long nameLength = RadiusFormat.getUnsignedInt(buffer);
        if (nameLength < 0L || nameLength > 1024L) {
            throw new RadiusException("KeepAlive rlm_jradius connection has been closed");
        }
        byte[] nameBytes = new byte[(int)nameLength];
        buffer.get(nameBytes);
        short messageType = RadiusFormat.getUnsignedByte(buffer);
        short packetCount = RadiusFormat.getUnsignedByte(buffer);
        RadiusPacket[] rp = PacketFactory.parse(buffer, packetCount);
        long length = RadiusFormat.getUnsignedInt(buffer);
        if (length > (long)buffer.remaining()) {
            throw new RadiusException("bad length");
        }
        AttributeList configItems = new AttributeList();
        format.unpackAttributes(configItems, buffer, (int)length);
        request.setConfigItems(configItems);
        request.setSender(new String(nameBytes));
        request.setType(messageType);
        request.setPackets(rp);
        return request;
    }
}

