/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import net.jradius.client.RadiusClient;
import net.jradius.exception.RadiusException;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.RadiusAttribute;

public abstract class RadiusAuthenticator {
    protected RadiusClient client;
    protected RadiusAttribute username;
    protected RadiusAttribute password;
    protected RadiusAttribute classAttribute;
    protected RadiusAttribute stateAttribute;

    public abstract String getAuthName();

    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException {
        this.client = c;
        if (this.username == null) {
            this.username = p.findAttribute(1L);
            if (this.username == null) {
                throw new RadiusException("You must at least have a User-Name attribute in a Access-Request");
            }
        }
        if (this.password == null) {
            this.password = p.findAttribute(2L);
        }
    }

    public abstract void processRequest(RadiusPacket var1) throws RadiusException;

    public void processChallenge(RadiusPacket request, RadiusPacket challenge) throws RadiusException {
        this.classAttribute = challenge.findAttribute(25L);
        if (this.classAttribute != null) {
            request.overwriteAttribute(this.classAttribute);
        }
        this.stateAttribute = challenge.findAttribute(24L);
        if (this.stateAttribute != null) {
            request.overwriteAttribute(this.stateAttribute);
        }
    }

    public RadiusClient getClient() {
        return this.client;
    }

    public void setClient(RadiusClient client) {
        this.client = client;
    }

    protected byte[] getUsername() {
        return this.username == null ? null : this.username.getValue().getBytes();
    }

    protected byte[] getPassword() {
        if (this.password != null) {
            return this.password.getValue().getBytes();
        }
        return "".getBytes();
    }

    public void setUsername(RadiusAttribute userName) {
        this.username = userName;
    }

    public void setPassword(RadiusAttribute cleartextPassword) {
        this.password = cleartextPassword;
    }

    protected byte[] getClassAttribute() {
        return this.classAttribute == null ? null : this.classAttribute.getValue().getBytes();
    }

    protected byte[] getStateAttribute() {
        return this.stateAttribute == null ? null : this.stateAttribute.getValue().getBytes();
    }
}

