/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import org.codehaus.jackson.annotate.JsonIgnore;

public class JpaPagination {
    @JsonIgnore
    protected int rows;
    @JsonIgnore
    protected int pageResults = 20;
    @JsonIgnore
    protected int page = 1;
    @JsonIgnore
    protected int startRow;
    @JsonIgnore
    protected int endRow;
    @JsonIgnore
    protected String sidx;
    @JsonIgnore
    protected String sord;
    @JsonIgnore
    protected String sortKey;
    @JsonIgnore
    protected String orderBy;
    @JsonIgnore
    protected boolean pageable = false;
    protected String pageResultSelectUUID;

    @JsonIgnore
    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.pageResults = rows;
        this.calculate();
    }

    @JsonIgnore
    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
        this.calculate();
    }

    @JsonIgnore
    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
        this.setSortKey();
    }

    @JsonIgnore
    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
        this.setSortKey();
    }

    @JsonIgnore
    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    @JsonIgnore
    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void calculate() {
        if (this.page >= 1 && this.pageResults > 0) {
            this.startRow = (this.page - 1) * this.pageResults;
            this.endRow = this.startRow + this.pageResults;
        }
    }

    @JsonIgnore
    public int getPageResults() {
        return this.pageResults;
    }

    public void setPageResults(int pageResults) {
        this.pageResults = pageResults;
    }

    @JsonIgnore
    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey() {
        if (this.sidx != null && this.sord != null && !this.sidx.equals("") && !this.sord.equals("")) {
            this.sortKey = " " + this.sidx + " " + this.sord + " ";
            this.setOrderBy();
        }
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    @JsonIgnore
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy() {
        if (this.sortKey != null && !this.sortKey.equals("")) {
            this.orderBy = " ORDER BY  " + this.sidx + " " + this.sord + " ";
        }
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public void setPageable(boolean pageable) {
        this.pageable = pageable;
    }

    public void setPageable() {
        this.setPageable(true);
    }

    public void setPageResultSelectUUID(String pageResultSelectUUID) {
        this.pageResultSelectUUID = pageResultSelectUUID;
    }

    public String getPageResultSelectUUID() {
        return this.pageResultSelectUUID;
    }

    public String toString() {
        return "Pagination [rows=" + this.rows + ", pageResults=" + this.pageResults + ", page=" + this.page + ", startRow=" + this.startRow + ", endRow=" + this.endRow + ", sidx=" + this.sidx + ", sord=" + this.sord + ", sortKey=" + this.sortKey + ", orderBy=" + this.orderBy + ", pageable=" + this.pageable + "]";
    }
}

