/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.BigIntegerUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;
import org.apache.commons.codec.binary.Base64;

@Immutable
public class Base64URL
implements JSONAware {
    private final String value;

    public Base64URL(String base64URL) {
        if (base64URL == null) {
            throw new IllegalArgumentException("The Base64URL value must not be null");
        }
        this.value = base64URL;
    }

    public byte[] decode() {
        return Base64.decodeBase64(this.value);
    }

    public BigInteger decodeToBigInteger() {
        return new BigInteger(1, this.decode());
    }

    public String decodeToString() {
        try {
            return new String(this.decode(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String toJSONString() {
        return "\"" + JSONValue.escape(this.value) + "\"";
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Base64URL && this.toString().equals(object.toString());
    }

    public static Base64URL encode(byte[] bytes) {
        return new Base64URL(Base64.encodeBase64URLSafeString(bytes));
    }

    public static Base64URL encode(BigInteger bigInt) {
        return Base64URL.encode(BigIntegerUtils.toBytesUnsigned(bigInt));
    }

    public static Base64URL encode(String text) {
        try {
            return Base64URL.encode(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

