/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.mybatis.jpa.dialect.Dialect;
import org.apache.mybatis.jpa.persistence.JpaPagination;

public class SQLServerDialect
extends Dialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, JpaPagination pagination) {
        StringBuilder pagingSelectSql = new StringBuilder("");
        if (pagination.getPageSize() > 0) {
            pagingSelectSql.append("select top " + pagination.getPageSize() + " * from ( ");
            pagingSelectSql.append("select row_number() over() as rownumber,mybatis_query_temp_table.* from ( ");
            pagingSelectSql.append("mybatis_query_temp_table ) mybatis_query_temp_page ");
            if (pagination.getStartRow() > 0) {
                pagingSelectSql.append("where  rownumber > " + pagination.getStartRow());
            }
        } else {
            return sql;
        }
        return pagingSelectSql.toString();
    }

    @Override
    public String getPreparedStatementLimitString(String sql, JpaPagination pagination) {
        if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
            return String.valueOf(sql) + " limit ? , ?";
        }
        if (pagination.getPageSize() > 0) {
            return String.valueOf(sql) + " limit  ? ";
        }
        return String.valueOf(sql) + " limit ?";
    }

    @Override
    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPagination pagination) {
        try {
            if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
            } else if (pagination.getPageSize() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
            } else {
                preparedStatement.setInt(++parameterSize, 1000);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "SQLServerDialect [" + SQLServerDialect.class + "]";
    }
}

