/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security;

import jakarta.servlet.ServletRequest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Credential;

public class ServletRequestX509CredentialAdapter
extends BasicX509Credential
implements X509Credential {
    public static final String X509_CERT_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    public ServletRequestX509CredentialAdapter(ServletRequest request) {
        X509Certificate[] chain = (X509Certificate[])request.getAttribute(X509_CERT_REQUEST_ATTRIBUTE);
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Servlet request does not contain X.509 certificates in attribute javax.servlet.request.X509Certificate");
        }
        this.setEntityCertificate(chain[0]);
        this.setEntityCertificateChain(Arrays.asList(chain));
        this.setUsageType(UsageType.SIGNING);
    }
}

