/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class KBInterval
extends KBobject
implements Serializable,
Cloneable {
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int wholeSeconds;
    private int microSeconds;

    public KBInterval() {
        this.setType("interval");
    }

    public KBInterval(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    private int lookAhead(String value, int position, String find) {
        char[] tokens = find.toCharArray();
        int found = -1;
        for (int i = 0; i < tokens.length; ++i) {
            found = value.indexOf(tokens[i], position);
            if (found <= 0) continue;
            return found;
        }
        return found;
    }

    private void parseISO8601Format(String value) {
        int lookAhead;
        int i;
        String dateValue;
        int number = 0;
        String timeValue = null;
        int hasTime = value.indexOf(84);
        if (hasTime > 0) {
            dateValue = value.substring(1, hasTime);
            timeValue = value.substring(hasTime + 1);
        } else {
            dateValue = value.substring(1);
        }
        for (i = 0; i < dateValue.length(); ++i) {
            lookAhead = this.lookAhead(dateValue, i, "YMD");
            if (lookAhead <= 0) continue;
            number = Integer.parseInt(dateValue.substring(i, lookAhead));
            if (dateValue.charAt(lookAhead) == 'Y') {
                this.setYears(number);
            } else if (dateValue.charAt(lookAhead) == 'M') {
                this.setMonths(number);
            } else if (dateValue.charAt(lookAhead) == 'D') {
                this.setDays(number);
            }
            i = lookAhead;
        }
        if (timeValue != null) {
            for (i = 0; i < timeValue.length(); ++i) {
                lookAhead = this.lookAhead(timeValue, i, "HMS");
                if (lookAhead <= 0) continue;
                number = Integer.parseInt(timeValue.substring(i, lookAhead));
                if (timeValue.charAt(lookAhead) == 'H') {
                    this.setHours(number);
                } else if (timeValue.charAt(lookAhead) == 'M') {
                    this.setMinutes(number);
                } else if (timeValue.charAt(lookAhead) == 'S') {
                    this.setSeconds(number);
                }
                i = lookAhead;
            }
        }
    }

    public KBInterval(int years, int months, int days, int hours, int minutes, double seconds) {
        this();
        this.setValue(years, months, days, hours, minutes, seconds);
    }

    @Override
    public void setValue(String value) throws SQLException {
        boolean PostgresFormat;
        boolean bl = PostgresFormat = !value.startsWith("@");
        if (value.startsWith("P")) {
            this.parseISO8601Format(value);
            return;
        }
        if (!PostgresFormat && value.length() == 3 && value.charAt(2) == '0') {
            this.setValue(0, 0, 0, 0, 0, 0.0);
            return;
        }
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        try {
            String valueToken = null;
            value = value.replace('+', ' ').replace('@', ' ');
            StringTokenizer st = new StringTokenizer(value);
            int i = 1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (i & true) {
                    int endHours = token.indexOf(58);
                    if (endHours == -1) {
                        valueToken = token;
                    } else {
                        int offset = token.charAt(0) == '-' ? 1 : 0;
                        hours = KBInterval.nullSafeIntGet(token.substring(offset + 0, endHours));
                        minutes = KBInterval.nullSafeIntGet(token.substring(endHours + 1, endHours + 3));
                        int endMinutes = token.indexOf(58, endHours + 1);
                        if (endMinutes != -1) {
                            seconds = KBInterval.nullSafeDoubleGet(token.substring(endMinutes + 1));
                        }
                        if (offset == 1) {
                            hours = -hours;
                            minutes = -minutes;
                            seconds = -seconds;
                        }
                        valueToken = null;
                    }
                } else if (token.startsWith("year")) {
                    years = KBInterval.nullSafeIntGet(valueToken);
                } else if (token.startsWith("mon")) {
                    months = KBInterval.nullSafeIntGet(valueToken);
                } else if (token.startsWith("day")) {
                    days = KBInterval.nullSafeIntGet(valueToken);
                } else if (token.startsWith("hour")) {
                    hours = KBInterval.nullSafeIntGet(valueToken);
                } else if (token.startsWith("min")) {
                    minutes = KBInterval.nullSafeIntGet(valueToken);
                } else if (token.startsWith("sec")) {
                    seconds = KBInterval.nullSafeDoubleGet(valueToken);
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new KSQLException(GT.tr("Conversion of interval failed", new Object[0]), KSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)e);
        }
        if (!PostgresFormat && value.endsWith("ago")) {
            this.setValue(-years, -months, -days, -hours, -minutes, -seconds);
        } else {
            this.setValue(years, months, days, hours, minutes, seconds);
        }
    }

    public void setValue(int years, int months, int days, int hours, int minutes, double seconds) {
        this.setYears(years);
        this.setMonths(months);
        this.setDays(days);
        this.setHours(hours);
        this.setMinutes(minutes);
        this.setSeconds(seconds);
    }

    @Override
    public String getValue() {
        return this.years + " years " + this.months + " mons " + this.days + " days " + this.hours + " hours " + this.minutes + " mins " + this.wholeSeconds + '.' + this.microSeconds + " secs";
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public double getSeconds() {
        if (this.microSeconds < 0) {
            if (this.wholeSeconds == 0) {
                return Double.parseDouble("-0." + -this.microSeconds);
            }
            return Double.parseDouble("" + this.wholeSeconds + '.' + -this.microSeconds);
        }
        return Double.parseDouble("" + this.wholeSeconds + '.' + this.microSeconds);
    }

    public int getWholeSeconds() {
        return this.wholeSeconds;
    }

    public int getMicroSeconds() {
        return this.microSeconds;
    }

    public void setSeconds(double seconds) {
        String str = Double.toString(seconds);
        int decimal = str.indexOf(46);
        if (decimal > 0) {
            String micSeconds = str.substring(decimal + 1);
            int power = 6 - micSeconds.length();
            this.microSeconds = Integer.parseInt(micSeconds) * (int)Math.pow(10.0, power);
            this.wholeSeconds = Integer.parseInt(str.substring(0, decimal));
        } else {
            this.microSeconds = 0;
            this.wholeSeconds = Integer.parseInt(str);
        }
        if (seconds < 0.0) {
            this.microSeconds = -this.microSeconds;
        }
    }

    public void add(Calendar cal) {
        int milliseconds = (this.microSeconds + (this.microSeconds < 0 ? -500 : 500)) / 1000 + this.wholeSeconds * 1000;
        cal.add(14, milliseconds);
        cal.add(12, this.getMinutes());
        cal.add(10, this.getHours());
        cal.add(5, this.getDays());
        cal.add(2, this.getMonths());
        cal.add(1, this.getYears());
    }

    public void add(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.add(cal);
        date.setTime(cal.getTime().getTime());
    }

    public void add(KBInterval interval) {
        interval.setYears(interval.getYears() + this.getYears());
        interval.setMonths(interval.getMonths() + this.getMonths());
        interval.setDays(interval.getDays() + this.getDays());
        interval.setHours(interval.getHours() + this.getHours());
        interval.setMinutes(interval.getMinutes() + this.getMinutes());
        interval.setSeconds(interval.getSeconds() + this.getSeconds());
    }

    public void scale(int factor) {
        this.setYears(factor * this.getYears());
        this.setMonths(factor * this.getMonths());
        this.setDays(factor * this.getDays());
        this.setHours(factor * this.getHours());
        this.setMinutes(factor * this.getMinutes());
        this.setSeconds((double)factor * this.getSeconds());
    }

    private static int nullSafeIntGet(String value) throws NumberFormatException {
        return value == null ? 0 : Integer.parseInt(value);
    }

    private static double nullSafeDoubleGet(String value) throws NumberFormatException {
        return value == null ? 0.0 : Double.parseDouble(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KBInterval)) {
            return false;
        }
        KBInterval pgi = (KBInterval)obj;
        return pgi.years == this.years && pgi.months == this.months && pgi.days == this.days && pgi.hours == this.hours && pgi.minutes == this.minutes && pgi.wholeSeconds == this.wholeSeconds && pgi.microSeconds == this.microSeconds;
    }

    @Override
    public int hashCode() {
        return (((((((248 + this.microSeconds) * 31 + this.wholeSeconds) * 31 + this.minutes) * 31 + this.hours) * 31 + this.days) * 31 + this.months) * 31 + this.years) * 31;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

